#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Mhakna Gramura and Fairy Bell
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250814.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='mhakna-gramura-and-fairy-bell'
GAME_NAME='Mhakna Gramura and Fairy Bell'

ARCHIVE_BASE_0_NAME='mhakna_gramura_and_fairy_bell_gog_1_26679.sh'
ARCHIVE_BASE_0_MD5='f54f86a4496b682ef7e7fb251d50c350'
ARCHIVE_BASE_0_SIZE='2000000'
ARCHIVE_BASE_0_VERSION='1.0-gog.26679'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/mhakna_gramura_and_fairy_bell'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_FILES='
libavcodec.so.57
libavformat.so.57
libavresample.so.3
libavutil.so.55
libGLEW.so.1.7
libpng12.so.0
libpython2.7.so.1.0
libswresample.so.2
libswscale.so.4'
CONTENT_LIBS_BIN64_RELATIVE_PATH='lib/linux-x86_64'
CONTENT_LIBS_BIN64_FILES="$CONTENT_LIBS_FILES"
CONTENT_LIBS_BIN32_RELATIVE_PATH='lib/linux-i686'
CONTENT_LIBS_BIN32_FILES="$CONTENT_LIBS_FILES"
CONTENT_GAME_BIN64_FILES='
lib/linux-x86_64/eggs
lib/linux-x86_64/lib
lib/linux-x86_64/fairybell
lib/linux-x86_64/python
lib/linux-x86_64/pythonw
lib/linux-x86_64/zsync
lib/linux-x86_64/zsyncmake'
CONTENT_GAME_BIN32_FILES='
lib/linux-i686/eggs
lib/linux-i686/lib
lib/linux-i686/fairybell
lib/linux-i686/python
lib/linux-i686/pythonw
lib/linux-i686/zsync
lib/linux-i686/zsyncmake'
CONTENT_GAME_DATA_FILES='
game
renpy
lib/pythonlib2.7
fairybell.py'

## System-provided Ren'Py can not be used with this game, as it causes a crash on launch:
##
## Full traceback:
##   File "/usr/share/games/renpy/renpy/bootstrap.py", line 359, in bootstrap
##     renpy.main.main()
##   File "/usr/share/games/renpy/renpy/main.py", line 459, in main
##     renpy.game.script.load_script() # sets renpy.game.script.
##   File "/usr/share/games/renpy/renpy/script.py", line 359, in load_script
##     self.load_appropriate_file(".rpyc", [ "_ren.py", ".rpy" ], dir, fn, initcode)
##   File "/usr/share/games/renpy/renpy/script.py", line 942, in load_appropriate_file
##     self.finish_load(stmts, initcode, filename=lastfn) # type: ignore
##   File "/usr/share/games/renpy/renpy/script.py", line 602, in finish_load
##     node.early_execute()
##   File "/usr/share/games/renpy/renpy/ast.py", line 880, in early_execute
##     renpy.python.py_exec_bytecode(self.code.bytecode, self.hide, store=self.store)
##   File "/usr/share/games/renpy/renpy/python.py", line 1178, in py_exec_bytecode
##     exec(bytecode, globals, locals)
##   File "game/9i/investigation.rpy", line 2978, in <module>
##   File "/usr/share/games/renpy/renpy/statements.py", line 259, in register
##     raise Exception("Unknown \"block\" argument value: {}".format(block))
## Exception: Unknown "block" argument value: auto
APP_MAIN_EXE_BIN64='lib/linux-x86_64/fairybell'
APP_MAIN_EXE_BIN32='lib/linux-i686/fairybell'
APP_MAIN_OPTIONS='-EO fairybell.py'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libfreetype.so.6
libGL.so.1
libGLU.so.1
libjpeg.so.62
libm.so.6
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libSDL2_image-2.0.so.0
libSDL2_ttf-2.0.so.0
libutil.so.1
libX11.so.6
libXext.so.6
libXi.so.6
libXmu.so.6
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialisation actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
