#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Bernd Schumacher
set -o errexit

###
# The Pillars of the Earth expansions:
# - Book 2 & 3
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250922.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='the-pillars-of-the-earth'
GAME_NAME='The Pillars of the Earth'

EXPANSION_ID_BOOK23='book-2-3'
EXPANSION_NAME_BOOK23='Book 2 & 3'

ARCHIVE_BASE_BOOK23_0_NAME='the_pillars_of_the_earth_book_2_3_en_1_1_703_19573.sh'
ARCHIVE_BASE_BOOK23_0_MD5='5c2237200b2bbec548bd507645797d1e'
ARCHIVE_BASE_BOOK23_0_SIZE='1808404'
ARCHIVE_BASE_BOOK23_0_VERSION='1.1.703-gog19573'
ARCHIVE_BASE_BOOK23_0_URL='https://www.gog.com/game/ken_folletts_the_pillars_of_the_earth_season_pass'


CONTENT_PATH_DEFAULT='data/noarch/game'

CONTENT_GAME_DATA_COMMON_BOOK23_FILES='
data.vis'

CONTENT_GAME_DATA_BOOK23_FILES='
videos'

PACKAGES_LIST='
PKG_DATA_COMMON_BOOK23
PKG_DATA_BOOK23'

PKG_PARENT_ID="$GAME_ID"

PKG_DATA_BOOK23_DEPENDENCIES_SIBLINGS='
PKG_DATA_COMMON_BOOK23
PKG_PARENT'

PKG_DATA_COMMON_ID="${GAME_ID}-data-common"
PKG_DATA_COMMON_BOOK23_ID="${PKG_DATA_COMMON_ID}-${EXPANSION_ID_BOOK23}"
PKG_DATA_BOOK23_ID="${GAME_ID}-data-${EXPANSION_ID_BOOK23}"

PKG_DATA_COMMON_BOOK23_PROVIDES="
$PKG_DATA_COMMON_ID"

PKG_DATA_COMMON_BOOK23_DESCRIPTION='data - common files between base game and expansion'


# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
