## Instructions for working with Rust in Chromium

### Documentation

Take into account the following documentation:
* Consult `docs/rust.md` for general usage of Rust in Chromium.
* Consult  `third_party/rust/README-importing-new-crates.md` for information 
  on adding new Rust crates.

### Adding new crates

When adding the new crates as a dependency to an existing component, make sure
you use the the lib target in the BUILD.gn that is generated by gnrt Chromium
tooling.  The BUILD.gn for a rust crate is found in
`third_party/rust/<crate-name with underscores>/<Version as v0_8 for example for
version 0.8>.

Do no try to recreate a full build file for building the Rust code - that is
already done by the gnrt generated BUILD.gn file.

When working with Rust crates that have - hyphens in their name, note that
Chromium tooling translates these to underscores _ when creating directories for
these crates. So when creating OWNERS files, or when referring to BUILD.gn files
generated for a crate, or generally content within such a crate, make sure not
to use hyphens but underscores.

### Updating Crates

For rolling and updating Rust crates, carefully look at the instructions in:
`tools/crates/create_update_cl.md`. Weigh whether an automated, script-based
approach works, or if the "manual mode" needs to be followed.
