/*
 * $XConsortium: Reversi.h,v 1.24 89/07/21 01:48:51 kit Exp $
 */

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#ifndef _XawReversi_h
#define _XawReversi_h

/***********************************************************************
 *
 * Reversi Widget
 *
 ***********************************************************************/

#include <X11/Xaw/Simple.h>
#include <X11/Xmu/Converters.h>

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 bitmap		     Pixmap		Pixmap		None
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 cursor		     Cursor		Cursor		None
 destroyCallback     Callback		XtCallbackList	NULL
 font		     Font		XFontStruct*	XtDefaultFont
 foreground	     Foreground		Pixel		XtDefaultForeground
 height		     Height		Dimension	text height
 insensitiveBorder   Insensitive	Pixmap		Gray
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 sensitive	     Sensitive		Boolean		True
 width		     Width		Dimension	text width
 x		     Position		Position	0
 y		     Position		Position	0

*/

#define XtNwhite "white"
#define XtNblack "black"
#define XtNgrid "grid"

typedef enum _ReversiStone { StoneWhite, StoneBlack, StoneNone } ReversiStone;

/* Class record constants */

extern WidgetClass reversiWidgetClass;

typedef struct _ReversiMove {
    int	x, y;
} ReversiMove, *ReversiMovePtr;

typedef struct _ReversiClassRec *ReversiWidgetClass;
typedef struct _ReversiRec      *ReversiWidget;

#define XtNstoneCallback "stoneCallback"
#define XtCStoneCallback "StoneCallback"

extern void	XawReversiSetSpot (
#if NeedFunctionPrototypes
				   Widget,
				   int, int,
				   ReversiStone
#endif
				   );
extern void	XawReversiAnimateSpot (
#if NeedFunctionPrototypes
				       Widget,
				       int, int,
				       ReversiStone, ReversiStone,
				       unsigned long,
				       int
#endif
				       );
				       
#endif /* _XawReversi_h */
/* DON'T ADD STUFF AFTER THIS #endif */
