/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MVQBUFRMESSAGESCANNER_H
#define MVQBUFRMESSAGESCANNER_H

#include "MvQAbstractMessageScanner.h"

#include <map>
#include <string>

class MvEccBufrMessage;
class BufrMetaData;

class BufrMessageScanner : public MvQAbstractMessageScanner
{
    Q_OBJECT

public:
    BufrMessageScanner(MvMessageMetaData* data, QObject* parent = 0);
    ~BufrMessageScanner();

protected slots:
    void slotProgress(int, MvKeyProfile*, int, int, std::vector<MvEccBufrMessage*>);
    void slotTotalMessageNumComputed();

signals:
    void progress(int, MvKeyProfile*, int, int, std::vector<MvEccBufrMessage*>);

protected:
    bool useThreadForScanning(qint64 fSize) const;
    bool precomputeMessageNum() const;
    void run();
    void loadKeyProfile(MvKeyProfile* prof);
    void readMessages(MvKeyProfile* prof);
    //void readMessage(MvKeyProfile* prof, codes_handle* ch, int msgCnt, int profIndex);
    void readMessage(MvKeyProfile* prof, codes_bufr_header* bh, int profIndex);

    BufrMetaData* bufrData_;
};

#endif
