<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Golden Ratio (φ)

> [Golden ratio][phi].

<section class="intro">

The [golden ratio][phi] can be defined algebraically as

<!-- <equation class="equation" label="eq:golden_ratio" align="center" raw="\phi = \frac{1 + \sqrt{5}}{2}" alt="Golden ratio"> -->

<div class="equation" align="center" data-raw-text="\phi = \frac{1 + \sqrt{5}}{2}" data-equation="eq:golden_ratio">
    <img src="https://cdn.jsdelivr.net/gh/stdlib-js/stdlib@5d87cc7cb2c58aeb732872f89562d2c89571cc8a/lib/node_modules/@stdlib/constants/float64/phi/docs/img/equation_golden_ratio.svg" alt="Golden ratio">
    <br>
</div>

<!-- </equation> -->

</section>

<!-- /.intro -->

<section class="usage">

## Usage

```javascript
var PHI = require( '@stdlib/constants/float64/phi' );
```

#### PHI

The [golden ratio][phi-value].

```javascript
var bool = ( PHI === 1.618033988749895 );
// returns true
```

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better example using Fibonacci(?) -->

<!-- eslint no-undef: "error" -->

```javascript
var PHI = require( '@stdlib/constants/float64/phi' );

console.log( PHI );
// => 1.618033988749895
```

</section>

<!-- /.examples -->

<section class="links">

[phi]: http://en.wikipedia.org/wiki/Golden_ratio

[phi-value]: http://oeis.org/A001622

</section>

<!-- /.links -->
