<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Stats

[![NPM version][npm-image]][npm-url] [![Build Status][test-image]][test-url] [![Coverage Status][coverage-image]][coverage-url] [![dependencies][dependencies-image]][dependencies-url]

> Standard library statistical functions.

<section class="installation">

## Installation

```bash
npm install @stdlib/stats
```

</section>

<section class="usage">

## Usage

```javascript
var statistics = require( '@stdlib/stats' );
```

#### statistics

Standard library statistical functions.

```javascript
var stats = statistics;
// returns {...}
```

The namespace exposes the following statistical tests:

<!-- <toc pattern="+(*test*|chi2gof|anova1|wilcoxon)"> -->

<div class="namespace-toc">

-   <span class="signature">[`anova1( x, factor[, opts] )`][@stdlib/stats/anova1]</span><span class="delimiter">: </span><span class="description">perform a one-way analysis of variance.</span>
-   <span class="signature">[`bartlettTest( a[,b,...,k][, opts] )`][@stdlib/stats/bartlett-test]</span><span class="delimiter">: </span><span class="description">compute Bartlett’s test for equal variances.</span>
-   <span class="signature">[`binomialTest( x[, n][, opts] )`][@stdlib/stats/binomial-test]</span><span class="delimiter">: </span><span class="description">exact test for the success probability in a Bernoulli experiment.</span>
-   <span class="signature">[`chi2gof( x, y[, ...args][, opts] )`][@stdlib/stats/chi2gof]</span><span class="delimiter">: </span><span class="description">perform a chi-square goodness-of-fit test.</span>
-   <span class="signature">[`chi2test( x[, opts] )`][@stdlib/stats/chi2test]</span><span class="delimiter">: </span><span class="description">perform a chi-square independence test.</span>
-   <span class="signature">[`flignerTest( a[,b,...,k][, opts] )`][@stdlib/stats/fligner-test]</span><span class="delimiter">: </span><span class="description">compute the Fligner-Killeen test for equal variances.</span>
-   <span class="signature">[`kruskalTest( a[,b,...,k][, opts] )`][@stdlib/stats/kruskal-test]</span><span class="delimiter">: </span><span class="description">compute the Kruskal-Wallis test for equal medians.</span>
-   <span class="signature">[`kstest( x, y[, ...params][, opts] )`][@stdlib/stats/kstest]</span><span class="delimiter">: </span><span class="description">one-sample Kolmogorov-Smirnov goodness-of-fit test.</span>
-   <span class="signature">[`leveneTest( x[, y, ..., z][, opts] )`][@stdlib/stats/levene-test]</span><span class="delimiter">: </span><span class="description">compute Levene's test for equal variances.</span>
-   <span class="signature">[`pcorrtest( x, y[, opts] )`][@stdlib/stats/pcorrtest]</span><span class="delimiter">: </span><span class="description">compute a Pearson product-moment correlation test between paired samples.</span>
-   <span class="signature">[`ttest( x[, y][, opts] )`][@stdlib/stats/ttest]</span><span class="delimiter">: </span><span class="description">one-sample and paired Student's t-Test.</span>
-   <span class="signature">[`ttest2( x, y[, opts] )`][@stdlib/stats/ttest2]</span><span class="delimiter">: </span><span class="description">two-sample Student's t-Test.</span>
-   <span class="signature">[`vartest( x, y[, opts] )`][@stdlib/stats/vartest]</span><span class="delimiter">: </span><span class="description">two-sample F-test for equal variances.</span>
-   <span class="signature">[`wilcoxon( x[, y][, opts] )`][@stdlib/stats/wilcoxon]</span><span class="delimiter">: </span><span class="description">one-sample and paired Wilcoxon signed rank test.</span>
-   <span class="signature">[`ztest( x, sigma[, opts] )`][@stdlib/stats/ztest]</span><span class="delimiter">: </span><span class="description">one-sample z-Test.</span>
-   <span class="signature">[`ztest2( x, y, sigmax, sigmay[, opts] )`][@stdlib/stats/ztest2]</span><span class="delimiter">: </span><span class="description">two-sample z-Test.</span>

</div>

<!-- </toc> -->

In addition, it contains an assortment of functions for computing statistics incrementally as part of the `incr` sub-namespace and functions for computing statistics over iterators in the `iterators` namespace.

<!-- <toc pattern="+(incr|iter)"> -->

<div class="namespace-toc">

-   <span class="signature">[`incr`][@stdlib/stats/incr]</span><span class="delimiter">: </span><span class="description">standard library functions for computing statistics incrementally.</span>
-   <span class="signature">[`iterators`][@stdlib/stats/iter]</span><span class="delimiter">: </span><span class="description">standard library functions for computing statistics over iterators.</span>

</div>

<!-- </toc> -->

The `base` sub-namespace contains functions to calculate statistics alongside a `dists` namespace containing functions related to a wide assortment of probability distributions.

Other statistical functions included are:

<!-- <toc pattern="*" ignore="+(*test*|chi2gof|anova1)" ignore="incr" ignore="iterators" > -->

<div class="namespace-toc">

-   <span class="signature">[`kde2d()`][@stdlib/stats/kde2d]</span><span class="delimiter">: </span><span class="description">two-dimensional kernel density estimation.</span>
-   <span class="signature">[`lowess( x, y[, opts] )`][@stdlib/stats/lowess]</span><span class="delimiter">: </span><span class="description">locally-weighted polynomial regression via the LOWESS algorithm.</span>
-   <span class="signature">[`padjust( pvals, method[, comparisons] )`][@stdlib/stats/padjust]</span><span class="delimiter">: </span><span class="description">adjust supplied p-values for multiple comparisons.</span>
-   <span class="signature">[`ranks( arr[, opts] )`][@stdlib/stats/ranks]</span><span class="delimiter">: </span><span class="description">compute ranks for values of an array-like object.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var statistics = require( '@stdlib/stats' );

console.log( objectKeys( statistics ) );
```

</section>

<!-- /.examples -->


<section class="main-repo" >

* * *

## Notice

This package is part of [stdlib][stdlib], a standard library for JavaScript and Node.js, with an emphasis on numerical and scientific computing. The library provides a collection of robust, high performance libraries for mathematics, statistics, streams, utilities, and more.

For more information on the project, filing bug reports and feature requests, and guidance on how to develop [stdlib][stdlib], see the main project [repository][stdlib].

#### Community

[![Chat][chat-image]][chat-url]

---

## License

See [LICENSE][stdlib-license].


## Copyright

Copyright &copy; 2016-2021. The Stdlib [Authors][stdlib-authors].

</section>

<!-- /.stdlib -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[npm-image]: http://img.shields.io/npm/v/@stdlib/stats.svg
[npm-url]: https://npmjs.org/package/@stdlib/stats

[test-image]: https://github.com/stdlib-js/stats/actions/workflows/test.yml/badge.svg
[test-url]: https://github.com/stdlib-js/stats/actions/workflows/test.yml

[coverage-image]: https://img.shields.io/codecov/c/github/stdlib-js/stats/main.svg
[coverage-url]: https://codecov.io/github/stdlib-js/stats?branch=main

[dependencies-image]: https://img.shields.io/david/stdlib-js/stats.svg
[dependencies-url]: https://david-dm.org/stdlib-js/stats/main

[chat-image]: https://img.shields.io/gitter/room/stdlib-js/stdlib.svg
[chat-url]: https://gitter.im/stdlib-js/stdlib/

[stdlib]: https://github.com/stdlib-js/stdlib

[stdlib-authors]: https://github.com/stdlib-js/stdlib/graphs/contributors

[stdlib-license]: https://raw.githubusercontent.com/stdlib-js/stats/main/LICENSE

<!-- <toc-links> -->

[@stdlib/stats/kde2d]: https://github.com/stdlib-js/stats/tree/main/kde2d

[@stdlib/stats/lowess]: https://github.com/stdlib-js/stats/tree/main/lowess

[@stdlib/stats/padjust]: https://github.com/stdlib-js/stats/tree/main/padjust

[@stdlib/stats/ranks]: https://github.com/stdlib-js/stats/tree/main/ranks

[@stdlib/stats/incr]: https://github.com/stdlib-js/stats/tree/main/incr

[@stdlib/stats/iter]: https://github.com/stdlib-js/stats/tree/main/iter

[@stdlib/stats/anova1]: https://github.com/stdlib-js/stats/tree/main/anova1

[@stdlib/stats/bartlett-test]: https://github.com/stdlib-js/stats/tree/main/bartlett-test

[@stdlib/stats/binomial-test]: https://github.com/stdlib-js/stats/tree/main/binomial-test

[@stdlib/stats/chi2gof]: https://github.com/stdlib-js/stats/tree/main/chi2gof

[@stdlib/stats/chi2test]: https://github.com/stdlib-js/stats/tree/main/chi2test

[@stdlib/stats/fligner-test]: https://github.com/stdlib-js/stats/tree/main/fligner-test

[@stdlib/stats/kruskal-test]: https://github.com/stdlib-js/stats/tree/main/kruskal-test

[@stdlib/stats/kstest]: https://github.com/stdlib-js/stats/tree/main/kstest

[@stdlib/stats/levene-test]: https://github.com/stdlib-js/stats/tree/main/levene-test

[@stdlib/stats/pcorrtest]: https://github.com/stdlib-js/stats/tree/main/pcorrtest

[@stdlib/stats/ttest]: https://github.com/stdlib-js/stats/tree/main/ttest

[@stdlib/stats/ttest2]: https://github.com/stdlib-js/stats/tree/main/ttest2

[@stdlib/stats/vartest]: https://github.com/stdlib-js/stats/tree/main/vartest

[@stdlib/stats/wilcoxon]: https://github.com/stdlib-js/stats/tree/main/wilcoxon

[@stdlib/stats/ztest]: https://github.com/stdlib-js/stats/tree/main/ztest

[@stdlib/stats/ztest2]: https://github.com/stdlib-js/stats/tree/main/ztest2

<!-- </toc-links> -->

</section>

<!-- /.links -->
