/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Arcsine distribution differential entropy.
*
* @module @stdlib/stats/base/dists/arcsine/entropy
*
* @example
* var entropy = require( '@stdlib/stats/base/dists/arcsine/entropy' );
*
* var v = entropy( 0.0, 1.0 );
* // returns ~-0.242
*
* v = entropy( 4.0, 12.0 );
* // returns ~1.838
*
* v = entropy( 2.0, 8.0 );
* // returns ~1.55
*/

// MODULES //

var entropy = require( './main.js' );


// EXPORTS //

module.exports = entropy;
