#/
# @license Apache-2.0
#
# Copyright (c) 2017 The Stdlib Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#/

# VARIABLES #

# Define the path to the remark configuration file:
REMARK_TOC_CONF ?= $(CONFIG_DIR)/remark/.remarkrc.js

# Define the path to the remark ignore file:
# REMARK_TOC_IGNORE ?= $(CONFIG_DIR)/remark/.remarkignore FIXME
REMARK_TOC_IGNORE ?= $(ROOT_DIR)/.remarkignore

# Define the path to a plugin which processes Markdown table of contents comments:
REMARK_TOC_PLUGIN ?= $(TOOLS_PKGS_DIR)/remark/plugins/remark-namespace-toc
REMARK_TOC_PLUGIN_SETTINGS ?=
REMARK_TOC_PLUGIN_FLAGS ?= --use $(REMARK_TOC_PLUGIN)=$(REMARK_TOC_PLUGIN_SETTINGS)

# Define command-line options when invoking the remark executable:
REMARK_TOC_FLAGS ?= \
	--ext $(MARKDOWN_FILENAME_EXT) \
	--rc-path $(REMARK_TOC_CONF) \
	--ignore-path $(REMARK_TOC_IGNORE)

# Define the remark output option:
REMARK_TOC_OUTPUT_FLAG ?= --output


# RULES #

#/
# Updates the table of contents of namespace Markdown files.
#
# ## Notes
#
# -   This rule is useful when wanting to glob for Markdown files (e.g., process all Markdown files for a particular package).
# -   In order to update table of contents, a namespace Markdown file must contain namespace table of contents comments.
#
# @param {string} [MARKDOWN_FILTER] - file path pattern (e.g., `.*/math/base/special/.*`)
# @param {string} [MARKDOWN_PATTERN] - filename pattern (e.g., `*.md`)
#
# @example
# make markdown-namespace-tocs
#
# @example
# make markdown-namespace-tocs MARKDOWN_PATTERN='README.md' MARKDOWN_FILTER='.*/math/base/special/.*'
#/
markdown-namespace-tocs: $(NODE_MODULES)
	$(QUIET) $(FIND_MARKDOWN_CMD) | grep '^[\/]\|^[a-zA-Z]:[/\]' | while read -r file; do \
		echo ""; \
		echo "Processing file: $$file"; \
		NODE_PATH="$(NODE_PATH)" \
		$(NODE) "$(REMARK)" \
			$$file \
			$(REMARK_TOC_FLAGS) \
			$(REMARK_TOC_PLUGIN_FLAGS) \
			$(REMARK_TOC_OUTPUT_FLAG) || exit 1; \
	done

.PHONY: markdown-namespace-tocs

#/
# Updates the table of contents of a specified list of namespace Markdown files.
#
# ## Notes
#
# -   This rule is useful when wanting to process a list of Markdown files generated by some other command (e.g., a list of changed Markdown files obtained via `git diff`).
# -   In order to update table of contents, a namespace Markdown file must contain namespace table of contents comments.
#
# @param {string} FILES - list of files
#
# @example
# make markdown-namespace-tocs-files FILES='/foo/foo.md /foo/bar.md'
#/
markdown-namespace-tocs-files: $(NODE_MODULES)
	$(QUIET) for file in $(FILES); do \
		echo ""; \
		echo "Processing file: $$file"; \
		NODE_PATH="$(NODE_PATH)" \
		$(NODE) "$(REMARK)" \
			$$file \
			$(REMARK_TOC_FLAGS) \
			$(REMARK_TOC_PLUGIN_FLAGS) \
			$(REMARK_TOC_OUTPUT_FLAG) || exit 1; \
	done

.PHONY: markdown-namespace-tocs-files
