/* 
 * Copyright 2013 ClinRisk Ltd.
 * 
 * This file is part of QRISK2-2014 (http://qrisk.org, original sources at http://svn.clinrisk.co.uk/opensource/qrisk2).
 * 
 * QRISK2-2014 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * QRISK2-2014 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with QRISK2-2014.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Additional terms
 * 
 * The following disclaimer must be held together with any risk score score generated by this code.  If the score is displayed, then this disclaimer must be displayed or otherwise be made easily accessible, e.g. by a prominent link alongside it.
 *   The initial version of this file, to be found at http://svn.clinrisk.co.uk/opensource/qrisk2, faithfully implements QRISK2-2014.
 *   ClinRisk Ltd. have released this code under the GNU Lesser General Public License to enable others to implement the algorithm faithfully.
 *   However, the nature of the GNU Lesser General Public License is such that we cannot prevent, for example, someone accidentally 
 *   altering the coefficients, getting the inputs wrong, or just poor programming.
 *   ClinRisk Ltd. stress, therefore, that it is the responsibility of the end user to check that the source that they receive produces the same results as the original code posted at http://svn.clinrisk.co.uk/opensource/qrisk2.
 *   Inaccurate implementations of risk scores can lead to wrong patients being given the wrong treatment.
 * 
 * End of additional terms
 *
 * 
 * This file has been auto-generated.
 * XML source: Q80_model_4_1.xml
 * STATA dta time stamp: 24 Sep 2013 22:39
 * This file was created on: Mon  9 Dec 2013 17:58:42 GMT
 */

#include <math.h>
#include <string.h>
#include <clinrisk/Q80_model_4_1.h>
#include <clinrisk/utils.h>

static double cvd_male_raw(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town
)
{
	double survivor[16] = {
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0.977699398994446,
		0,
		0,
		0,
		0,
		0
	};

	/* The conditional arrays */

	double Iethrisk[10] = {
		0,
		0,
		0.3567133647493443400000000,
		0.5369559608176189800000000,
		0.5190878419529624300000000,
		0.2182992106490147000000000,
		-0.3474174705898491800000000,
		-0.3674730037922803700000000,
		-0.3749664891426142700000000,
		-0.1926947742531604500000000
	};
	double Ismoke[5] = {
		0,
		0.2784649664157046200000000,
		0.6067834395168959500000000,
		0.7103835060989258700000000,
		0.8626172339181202900000000
	};

	/* Applying the fractional polynomial transforms */
	/* (which includes scaling)                      */

	double dage = age;
	dage=dage/10;
	double age_1 = pow(dage,-1);
	double age_2 = pow(dage,2);
	double dbmi = bmi;
	dbmi=dbmi/10;
	double bmi_1 = pow(dbmi,-2);
	double bmi_2 = pow(dbmi,-2)*log(dbmi);

	/* Centring the continuous variables */

	age_1 = age_1 - 0.232008963823318;
	age_2 = age_2 - 18.577636718750000;
	bmi_1 = bmi_1 - 0.146408438682556;
	bmi_2 = bmi_2 - 0.140651300549507;
	rati = rati - 4.377167701721191;
	sbp = sbp - 131.038314819335940;
	town = town - 0.151332527399063;

	/* Start of Sum */
	double a=0;

	/* The conditional sums */

	a += Iethrisk[ethrisk];
	a += Ismoke[smoke_cat];

	/* Sum from continuous values */

	a += age_1 * -17.6225543381945610000000000;
	a += age_2 * 0.0241873189298273640000000;
	a += bmi_1 * 1.7320282704272665000000000;
	a += bmi_2 * -7.2311754066699754000000000;
	a += rati * 0.1751387974012235100000000;
	a += sbp * 0.0101676305179196900000000;
	a += town * 0.0298177271496720960000000;

	/* Sum from boolean values */

	a += b_AF * 0.9890997526189402300000000;
	a += b_ra * 0.2541886209118611200000000;
	a += b_renal * 0.7949789230438320000000000;
	a += b_treatedhyp * 0.6229359479868044100000000;
	a += b_type1 * 1.3330353321463930000000000;
	a += b_type2 * 0.9372956828151940400000000;
	a += fh_cvd * 0.5923353736582422900000000;

	/* Sum from interaction terms */

	a += age_1 * (smoke_cat==1) * 0.9243747443632776000000000;
	a += age_1 * (smoke_cat==2) * 1.9597527500081284000000000;
	a += age_1 * (smoke_cat==3) * 2.9993544847631153000000000;
	a += age_1 * (smoke_cat==4) * 5.0370735254768100000000000;
	a += age_1 * b_AF * 8.2354205455482727000000000;
	a += age_1 * b_renal * -3.9747389951976779000000000;
	a += age_1 * b_treatedhyp * 7.8737743159167728000000000;
	a += age_1 * b_type1 * 5.4238504414460937000000000;
	a += age_1 * b_type2 * 5.0624161806530141000000000;
	a += age_1 * bmi_1 * 33.5437525167394240000000000;
	a += age_1 * bmi_2 * -129.9766738257203800000000000;
	a += age_1 * fh_cvd * 1.9279963874659789000000000;
	a += age_1 * sbp * 0.0523440892175620200000000;
	a += age_1 * town * -0.1730588074963540200000000;
	a += age_2 * (smoke_cat==1) * -0.0034466074038854394000000;
	a += age_2 * (smoke_cat==2) * -0.0050703431499952954000000;
	a += age_2 * (smoke_cat==3) * 0.0003216059799916440800000;
	a += age_2 * (smoke_cat==4) * 0.0031312537144240087000000;
	a += age_2 * b_AF * 0.0073291937255039966000000;
	a += age_2 * b_renal * -0.0261557073286531780000000;
	a += age_2 * b_treatedhyp * 0.0085556382622618121000000;
	a += age_2 * b_type1 * 0.0020586479482670723000000;
	a += age_2 * b_type2 * -0.0002328590770854172900000;
	a += age_2 * bmi_1 * 0.0811847212080794990000000;
	a += age_2 * bmi_2 * -0.2558919068850948300000000;
	a += age_2 * fh_cvd * -0.0056729073729663406000000;
	a += age_2 * sbp * -0.0000536584257307299330000;
	a += age_2 * town * -0.0010763305052605857000000;

	/* Calculate the score itself */
	double score = 100.0 * (1 - pow(survivor[surv], exp(a)) );
	return score;
}

static int cvd_male_validation(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town,char *errorBuf,int errorBufSize
)
{
	int ok=1;
	*errorBuf=0;
	if (!i_in_range(age,25,84)) {
		ok=0;
		strlcat(errorBuf,"error: age must be in range (25,84)\n",errorBufSize);
	}
	if (!is_boolean(b_AF)) {
		ok=0;
		strlcat(errorBuf,"error: b_AF must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_ra)) {
		ok=0;
		strlcat(errorBuf,"error: b_ra must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_renal)) {
		ok=0;
		strlcat(errorBuf,"error: b_renal must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_treatedhyp)) {
		ok=0;
		strlcat(errorBuf,"error: b_treatedhyp must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_type1)) {
		ok=0;
		strlcat(errorBuf,"error: b_type1 must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_type2)) {
		ok=0;
		strlcat(errorBuf,"error: b_type2 must be in range (0,1)\n",errorBufSize);
	}
	if (!d_in_range(bmi,20,40)) {
		ok=0;
		strlcat(errorBuf,"error: bmi must be in range (20,40)\n",errorBufSize);
	}
	if (!i_in_range(ethrisk,1,9)) {
		ok=0;
		strlcat(errorBuf,"error: ethrisk must be in range (1,9)\n",errorBufSize);
	}
	if (!is_boolean(fh_cvd)) {
		ok=0;
		strlcat(errorBuf,"error: fh_cvd must be in range (0,1)\n",errorBufSize);
	}
	if (!d_in_range(rati,1,12)) {
		ok=0;
		strlcat(errorBuf,"error: rati must be in range (1,12)\n",errorBufSize);
	}
	if (!d_in_range(sbp,70,210)) {
		ok=0;
		strlcat(errorBuf,"error: sbp must be in range (70,210)\n",errorBufSize);
	}
	if (!i_in_range(smoke_cat,0,4)) {
		ok=0;
		strlcat(errorBuf,"error: smoke_cat must be in range (0,4)\n",errorBufSize);
	}
        if (surv!=10) {
                ok=0;
                strlcat(errorBuf,"error: surv must be 10\n",errorBufSize);
        }
	if (!d_in_range(town,-7,11)) {
		ok=0;
		strlcat(errorBuf,"error: town must be in range (-7,11)\n",errorBufSize);
	}
	return ok;
}

double cvd_male(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town,int *error,char *errorBuf,int errorBufSize
)
{
	*error = 0;	int ok = cvd_male_validation(age,b_AF,b_ra,b_renal,b_treatedhyp,b_type1,b_type2,bmi,ethrisk,fh_cvd,rati,sbp,smoke_cat,surv,town,errorBuf,errorBufSize);
	if(!ok) { 
		*error = 1;
		return 0.0;
	}
	return cvd_male_raw(age,b_AF,b_ra,b_renal,b_treatedhyp,b_type1,b_type2,bmi,ethrisk,fh_cvd,rati,sbp,smoke_cat,surv,town);
}
