---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, notes de bas de page, style de note de bas de page, 
              footmisc
---

# Comment modifier le style de notes de bas de page ?

L'extension <ctanpkg:footmisc> permet de faire cela. Elle propose deux possibilités :

- l'option `symbol`, qui utilise un (petit) nombre de symboles 
  (et qui risque donc de poser problème s'il y a trop de notes de bas de page 
  dans le document) ;
- l'option `symbol*`, qui est semblable à `symbol` mais réinitialise le compteur 
  à chaque page.

Deux commandes principales sont mises à disposition :
- la commande `\DefineFNsymbols{⟨famille⟩}[⟨option⟩]{⟨liste⟩}` qui définit 
  un nom de `⟨famille⟩` de symboles donnés par la `⟨liste⟩`. 
  Les symboles sont donnés les uns à la suite des autres, sans séparateurs, 
  d'où les accolades pour encadrer ceux qui sont constitués de plus 
  d'un caractère. L'argument facultatif `⟨option⟩` permet de gérer 
  avec la valeur `math` une liste de symboles qui contiendrait 
  des symboles mathématiques, comme dans notre exemple ci-dessous (le symbole `\dagger`) ;
- la commande `\setfnsymbol{⟨famille⟩}` qui active la `⟨famille⟩` indiquée.

Voici un exemple d'utilisation.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

  \usepackage[symbol]{footmisc}
  % Définition de nos propres symboles
  \DefineFNsymbols{messymboles}[math]{*\dagger{**}%
                  {***}{\dagger\dagger}%
                  {\dagger\dagger\dagger}%
                  \S{\S\S}\P{\P\P}}

\begin{document}
Pour l'instant, les symboles par défaut sont
utilisés\footnote{La preuve\dots}.

\setfnsymbol{messymboles}  % Appel des symboles que nous avons définis.

À partir de maintenant, ce sont les symboles définis dans le 
préambule\footnote{En commençant, par le deuxième, puisque le compteur 
de notes vaut déjà $2$.}.

Les symboles sont utilisés dans l'ordre où ils ont été 
définis\footnote{Voici le troisième symbole.}.
\end{document}
```

L'extension propose quelques familles par défaut : `bringhurst`, `chicago`, 
`lamport`, `wiley`.

Il faut noter que la [documentation](texdoc:footmisc) de l'extension 
ne donne pas la description complète de `\DefineFNsymbols` (et le dit). 
En l'occurrence, elle n'évoque pas l'existence de l'option facultative.

:::{sources}
[footmisc package - remove star from footnote symbols](https://tex.stackexchange.com/q/16239), 
sur [TeX Stack Exchange](https://tex.stackexchange.com/).
:::