#!/bin/sh
#script to generate result files for TOPCOM clients:

PATH=/bin:/usr/bin:../src/:../src-reg:../../src/:../../src-reg

contents=`cat $1 | tr -d '\n'`

echo test file contains:
echo $contents

IFS='|'
read -r client inputfile options resultfile <<_EOF_
$contents
_EOF_

echo "client is     :" $client
echo "input file is :" $inputfile
echo "options are   :" $options
echo "result file is:" $resultfile

if [ -z $inputfile ]
then
    input=" "
else
    input="-i $inputfile"
    if [ ! -f $inputfile ]
    then
	echo $inputfile not found - FAILURE
	exit 1
    fi
fi

if [ -z $resultfile ]
then
    echo $resultfile not a valid file name - FAILURE
    exit 1
fi

strippedoptions=`echo $options | tr -d ' '`
strippedinputfile=`echo $inputfile | sed -e s/\.dat//g`

commandline="$client $input $options 2> /dev/null"

echo generating content for "$resultfile" using "$commandline" ...

testresult=`/bin/sh -c "$commandline"`

echo $testresult > ${resultfile}

#eof result generation
