##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# https://www.morningstarsecurity.com/research/whatweb
##
Plugin.define do
name "Webalizer-Log"
authors [
  "Brendan Coles <bcoles@gmail.com>", # 2011-05-20
]
version "0.1"
description "Webalizer is a fast, free web server log file analysis program. It produces highly detailed, easily configurable usage reports in HTML format, for viewing with a standard web browser."
website "http://www.webalizer.org/"

# Google results as at 2011-05-20 #
# 529 for intitle:"Usage Statistics for" "Monthly Statistics" "Generated by Webalizer"

# Dorks #
dorks [
'intitle:"Usage Statistics for" "Monthly Statistics" "Generated by Webalizer"'
]



# Matches #
matches [

# Version Detection # HTML Comment
{ :version=>/<!-- Generated by The Webalizer  Ver\. ([^\s]+) -->/ },
{ :version=>/<!-- Webalizer Version ([^\s]+) \(Mod: [\d]{1,2}-[a-zA-Z]{3}-[\d]{4}\) -->/ },

# Version Detection # Footer
{ :version=>/<A HREF="http:\/\/www\.webalizer\.org\/"><STRONG>Webalizer Version ([^<]+)<\/STRONG><\/A>/ },

]

end

