;TextAnnotation
(let ((tag "TextAnnotation") (params TextAnnotation::params) (text "pizz.") (oldtext #f))
    (define (do-direction)
        (let ()                  
          (define choice (RadioBoxMenu (cons (_ "Up") 'up)  (cons (_ "Down")  'down) (cons (_ "Auto")  'auto)))
           (case choice
            ((up)  "^")
            ((down) "_")
            (else "-"))))
    (define (do-bold)
        (let ()                  
          (define choice (RadioBoxMenu (cons (_ "Bold") 'bold)  (cons (_ "Light")  'light)))
           (case choice
            ((bold)  "\\bold ")
            ((light)  "\\medium ")
            (else ""))))         
    (define (do-italic)
        (let ()                  
          (define choice (RadioBoxMenu (cons (_ "Italic") 'italic)  (cons (_ "Normal")  'normal)))
           (case choice
            ((italic)  "\\italic ")
            ((normal)  "\\upright ")
            (else ""))))         
    (set! oldtext (d-DirectiveGet-standalone-display "TextAnnotation"))
    (if (and (not params) oldtext)
		(set! params "edit"))
    (if (not params)
		(set! params (cons 'default "ral.")))
    (if (equal? "edit" params)  
       (let ((choice (RadioBoxMenu (cons (_ "Help") 'help)  (cons (_ "Edit")  'edit)  (cons (_ "Advanced")  'advanced))))  
                       (case choice
							((edit) 
								(set! params (cons 'default oldtext)))
							((advanced) 
								(d-DirectiveTextEdit-standalone tag)
								(set! params 'unchanged))
								
							((help)  (d-InfoDialog "This places text tied to the position of the following note or chord.\nIt can't be placed after all music, but the positioning can be altered in the typeset (print) view by right-clicking on the text.")
								(set! params 'unchanged))
							(else
								(set! params 'unchanged)))))     
    (cond 
            ((string? params)
                     (let ((text params))
                        (StandaloneText tag text)))
            ((and (pair? params) (equal? (car params) 'fontsize))
                    (let ((value (cdr params)))
                        (set! tag (d-DirectiveGetTag-standalone))
                        (if value
                            (TweakRelativeFontSize tag value))))                     
            ((and (pair? params) (equal? (car params) 'default))
                    (set! text (d-GetUserInput (_ "Text Annotation") 
                                                (_ "Give text to be placed in score at cursor\n(it can be dragged in the typeset view)") 
                                                (cdr params)))
                    (if text 
                        (StandaloneText tag text (do-direction) (do-bold) (do-italic))
                        (set! params 'unchanged))))                     
	(if (not (equal? params 'unchanged))
		(begin
			(d-RefreshDisplay)
			(d-SetSaved #f))))
