/****************************************************************************
**
** Copyright (C) 2016 Klaralvdalens Datakonsult AB (KDAB).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "qseamlesscubemap.h"
#include "qrenderstate_p.h"
#include <private/qnode_p.h>

QT_BEGIN_NAMESPACE

namespace Qt3DRender {

/*!
    \class Qt3DRender::QSeamlessCubemap
    \brief Enables seamless cubemap texture filtering.
    \since 5.7
    \inmodule Qt3DRender

    When present in a state set, enables the seamless cubemap texture filtering
    as provided by the GL_ARB_seamless_cubemap extension (if available).
 */

/*!
    \qmltype SeamlessCubemap
    \brief Enables seamless cubemap texture filtering.
    \since 5.7
    \inqmlmodule Qt3D.Render
    \instantiates Qt3DRender::QSeamlessCubemap
    \inherits RenderState

    When present in a state set, enables the seamless cubemap texture filtering
    as provided by the GL_ARB_seamless_cubemap extension (if available).
 */


class QSeamlessCubemapPrivate : public QRenderStatePrivate
{
public:
    QSeamlessCubemapPrivate()
        : QRenderStatePrivate(Render::SeamlessCubemapMask)
    {
    }

    Q_DECLARE_PUBLIC(QSeamlessCubemap)
};

/*!
    The constructor creates a new QSeamlessCubemap::QSeamlessCubemap instance
    with the specified \a parent.
 */
QSeamlessCubemap::QSeamlessCubemap(QNode *parent)
    : QRenderState(*new QSeamlessCubemapPrivate, parent)
{
}

/*! \internal */
QSeamlessCubemap::~QSeamlessCubemap()
{
}

} // namespace Qt3DRender

QT_END_NAMESPACE

