// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file exposes services in the browser to the utility process.

#include "content/browser/utility_process_host.h"

#include "build/build_config.h"
#include "content/public/browser/content_browser_client.h"
#include "content/public/common/content_client.h"

#if defined(OS_LINUX) || defined(OS_CHROMEOS)
#include "components/services/font/public/mojom/font_service.mojom.h"  // nogncheck
#include "content/browser/font_service.h"  // nogncheck
#endif

namespace content {

void UtilityProcessHost::BindHostReceiver(
    mojo::GenericPendingReceiver receiver) {
#if defined(OS_LINUX) || defined(OS_CHROMEOS)
  if (auto font_receiver = receiver.As<font_service::mojom::FontService>()) {
    ConnectToFontService(std::move(font_receiver));
    return;
  }
#endif
  GetContentClient()->browser()->BindUtilityHostReceiver(std::move(receiver));
}

}  // namespace content
