---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, document en colonnes, plusieurs colonnes, 
              colonnes multiples, composer un article en colonnes
---

# Comment obtenir un document multicolonnes ?

## Avec les classes standard

L'option standard `twocolumn` permet de présenter un texte sur deux colonnes verticales :

```
\documentclass[twocolumn,french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux-texte      

\begin{document}
Voici un texte sur deux colonnes que \LaTeX{}
n'équilibre pas par lui-même (il remplit les
colonnes les unes après les autres). L'espace
entre les colonnes peut être modifié comme
indiqué plus loin. Une ligne de séparation des
colonnes peut également être insérée.

\lipsum[1-6]
\end{document}
```


## Avec des commandes de base

LaTeX propose par défaut deux commandes : 
- `\twocolumn[⟨texte introductif⟩]{⟨texte sur deux colonnes⟩}` ou plus simplement `\twocolumn`;
- `\onecolumn{⟨texte sur une colonne⟩}` ou plus simplement `\onecolumn`. 

Dans les deux cas, ces commandes passent une nouvelle page.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{lipsum}         % Du faux-texte 

  \setlength{\columnseprule}{0.5pt} % Rédéfinition du filet de sépération

\begin{document}
\twocolumn[Attention, voici qu'arrivent deux colonnes !]{\lipsum[1-4]}
\onecolumn{\lipsum[1-3]}
\end{document}
```


## Avec l'extension <ctanpkg:multicol>

L'extension <ctanpkg:multicol> permet d'agir localement sur la présentation des colonnes avec un environnement dédié, `multicols`. 
Ceci permet de basculer le nombre de colonnes en cours de page. En voici un exemple : 

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{multicol}       % Gestion de plusieurs colonnes

  \setlength{\columnseprule}{0.5pt} % Rédéfinition du filet de sépération

\begin{document}

\begin{multicols}{3}[Jamais trois sans trois]
   3~colonnes bien équilibrées. Je dirais même plus 3~colonnes 
   vraiment très bien équilibrées. N'est-ce pas ?
\end{multicols}

\begin{multicols}{2}[\section{Un peu changement}]
   2~colonnes bien équilibrées. Je dirais même plus 2~colonnes 
   vraiment très bien équilibrées. N'est-ce pas ?
\end{multicols}
\end{document}
```

Comme le montre l'exemple, pour ajouter un titre numéroté qui apparaisse sur toute la largeur de la page, 
il faut utiliser l'option `\section{⟨Titre⟩}` juste après `\begin{multicols}{⟨nb-col⟩}`.

Quelques compléments :
- pour qu'une ligne de séparation apparaisse entre les colonnes, 
  il faut utiliser : `\setlength{\columnseprule}{⟨dimension⟩}`, comme dans l'exemple ci-dessus.
- il est possible de redéfinir la largeur de l'espace inter-colonnes 
  en utilisant cette commande : `\setlength{\columnsep}{⟨dimension⟩}`.