CREATE GENERATOR CHANGE_NUM;

/* Domain definitions */
CREATE DOMAIN D_ACTION AS BLOB SUB_TYPE 0 SEGMENT SIZE 0;
CREATE DOMAIN CHANGE_DATE AS TIMESTAMP;
CREATE DOMAIN CHANGE_NUMBER AS INTEGER;
CREATE DOMAIN CHANGE_WHO AS VARCHAR(32);
CREATE DOMAIN CLASS AS CHAR(10);
CREATE DOMAIN DESCRIPTION AS BLOB SUB_TYPE 0 SEGMENT SIZE 80;
CREATE DOMAIN EXPLANATION AS BLOB SUB_TYPE 0 SEGMENT SIZE 0;
CREATE DOMAIN FACILITY AS CHAR(10);
CREATE DOMAIN FAC_CODE AS SMALLINT;
CREATE DOMAIN D_FILE AS VARCHAR(30);
CREATE DOMAIN FLAGS AS SMALLINT;
CREATE DOMAIN LANGUAGE AS VARCHAR(10);
CREATE DOMAIN LAST_CHANGE AS TIMESTAMP;
CREATE DOMAIN LOCALE AS VARCHAR(20);
CREATE DOMAIN MAX_NUMBER AS SMALLINT;
CREATE DOMAIN MODULE AS VARCHAR(32);
CREATE DOMAIN NUMBER AS SMALLINT;
CREATE DOMAIN OLD_SEQUENCE AS SMALLINT;
CREATE DOMAIN ROUTINE AS VARCHAR(32);
CREATE DOMAIN SEQUENCE AS SMALLINT;
CREATE DOMAIN SEVERITY AS SMALLINT;
CREATE DOMAIN SEVERITY_TEXT AS CHAR(7);
CREATE DOMAIN SQL_CLASS AS CHAR(2);
CREATE DOMAIN SQL_CODE AS SMALLINT;
CREATE DOMAIN SQL_SUBCLASS AS CHAR(3);
CREATE DOMAIN SYMBOL AS VARCHAR(32);
CREATE DOMAIN TEMPLATE AS BLOB SUB_TYPE 0 SEGMENT SIZE 256;
CREATE DOMAIN TEXT AS VARCHAR(118);
CREATE DOMAIN TRANSLATOR AS VARCHAR(32);
CREATE DOMAIN TRANS_DATE AS TIMESTAMP;
CREATE DOMAIN TRANS_NOTES AS BLOB SUB_TYPE 0 SEGMENT SIZE 0;
CREATE DOMAIN D_TYPE AS CHAR(12);
CREATE DOMAIN D_VALUE AS INTEGER;
CREATE DOMAIN VMS_CODE AS INTEGER;

COMMIT;

/* Tables */

CREATE TABLE FACILITIES (
    LAST_CHANGE  LAST_CHANGE,
    FACILITY     FACILITY NOT NULL CONSTRAINT FAC_2 UNIQUE,
    FAC_CODE     FAC_CODE NOT NULL CONSTRAINT FAC_1 PRIMARY KEY,
    MAX_NUMBER   MAX_NUMBER
);

CREATE TABLE HISTORY (
    CHANGE_NUMBER    CHANGE_NUMBER NOT NULL CONSTRAINT HIS_1 PRIMARY KEY,
    CHANGE_WHO       CHANGE_WHO NOT NULL,
    CHANGE_DATE      CHANGE_DATE NOT NULL,
    FAC_CODE         FAC_CODE NOT NULL /*REFERENCES FACILITIES*/,
    NUMBER           NUMBER NOT NULL,
    OLD_TEXT         TEXT,
    OLD_ACTION       D_ACTION,
    OLD_EXPLANATION  EXPLANATION,
    LOCALE           LOCALE,
    CODE             COMPUTED BY (fac_code * 10000 + number)
);

CREATE TABLE LOCALES (
    LOCALE       LOCALE NOT NULL CONSTRAINT PRIMARY_LOCALES PRIMARY KEY,
    DESCRIPTION  DESCRIPTION
);

CREATE TABLE MESSAGES (
    SYMBOL       SYMBOL,
    ROUTINE      ROUTINE,
    MODULE       MODULE,
    TRANS_NOTES  TRANS_NOTES,
    FAC_CODE     FAC_CODE NOT NULL REFERENCES FACILITIES,
    NUMBER       NUMBER NOT NULL,
    FLAGS        FLAGS,
    TEXT         TEXT,
    "ACTION"     D_ACTION,
    EXPLANATION  EXPLANATION,
    CODE         COMPUTED BY (fac_code * 10000 + number),
    CONSTRAINT MSG_1 UNIQUE(FAC_CODE, NUMBER)
);

CREATE TABLE SYMBOLS (
    SYMBOL    SYMBOL NOT NULL CONSTRAINT SYM2 PRIMARY KEY,
    "VALUE"   D_VALUE,
    CLASS     CLASS,
    "TYPE"    D_TYPE,
    SEQUENCE  SEQUENCE
);

CREATE TABLE SYSTEM_ERRORS (
    SQL_CODE       SQL_CODE,
    SQL_CLASS      SQL_CLASS,
    SQL_SUBCLASS   SQL_SUBCLASS,
    FAC_CODE       FAC_CODE NOT NULL REFERENCES FACILITIES,
    NUMBER         NUMBER NOT NULL,
    VMS_CODE       VMS_CODE,
    GDS_SYMBOL     SYMBOL NOT NULL CONSTRAINT SYSERR2 UNIQUE,
    SEVERITY       SEVERITY,
    SEVERITY_TEXT  SEVERITY_TEXT,
    CODE           COMPUTED BY (FAC_CODE * 10000 + NUMBER),
    SQL_STATE      COMPUTED BY (SQL_CLASS || SQL_SUBCLASS),
	CONSTRAINT SYSERR1 UNIQUE(FAC_CODE, NUMBER)
);

CREATE TABLE TEMPLATES (
    LANGUAGE  LANGUAGE,
    "FILE"    D_FILE,
    TEMPLATE  TEMPLATE
);

COMMIT;

CREATE TABLE TRANSMSGS (
    ENG_TEXT         TEXT,
    ENG_ACTION       D_ACTION,
    ENG_EXPLANATION  EXPLANATION,
    FAC_CODE         FAC_CODE NOT NULL REFERENCES FACILITIES,
    NUMBER           NUMBER NOT NULL,
    LOCALE           LOCALE NOT NULL CONSTRAINT UNKNOWN_LOCALE REFERENCES LOCALES,
    TEXT             TEXT,
    "ACTION"         D_ACTION,
    EXPLANATION      EXPLANATION,
    TRANSLATOR       TRANSLATOR,
    TRANS_DATE       TRANS_DATE,
    CODE             COMPUTED BY (fac_code * 10000 + number),
	CONSTRAINT TMSG_1 UNIQUE(LOCALE, FAC_CODE, NUMBER)
);

COMMIT;

/*  Index definitions for all user tables */
CREATE INDEX SYM1 ON SYMBOLS(CLASS, "TYPE");

COMMIT;

SET TERM ^ ;

/* Triggers */
CREATE TRIGGER FACILITIES$STORE FOR FACILITIES 
ACTIVE BEFORE INSERT POSITION 0 AS
begin
	new.last_change = CURRENT_TIMESTAMP;
end^

CREATE TRIGGER FACILITIES$MODIFY FOR FACILITIES
ACTIVE BEFORE UPDATE POSITION 0 AS
begin
	new.last_change = CURRENT_TIMESTAMP;
end^

CREATE TRIGGER MESSAGES$MODIFY FOR MESSAGES 
ACTIVE AFTER UPDATE POSITION 0 AS
begin
	update facilities
		set last_change = current_timestamp
		where fac_code = new.fac_code;
end^
 
CREATE TRIGGER MSGS$MODIFY FOR MESSAGES 
ACTIVE AFTER UPDATE POSITION 1 AS
begin
   if (new.text <> old.text) then
      begin
		insert into history (change_number, change_date, change_who, fac_code,
							 number, old_text, old_action, old_explanation, locale)
			values (gen_id(change_num, 1), current_timestamp, current_user,
					old.fac_code, old.number, old.text, old."ACTION",
					old.explanation, 'c_pg');
      end
end^
 
CREATE TRIGGER TRANSMSGS$STORE FOR TRANSMSGS 
ACTIVE BEFORE INSERT POSITION 0 AS
begin
   if (new.translator is NULL) then
	   new.translator = current_user;
   if (new.trans_date is NULL) then
	   new.trans_date = current_timestamp;
end^
 
CREATE TRIGGER TRANSMSGS$MODIFY FOR TRANSMSGS 
ACTIVE AFTER UPDATE POSITION 0 AS
begin
   if (new.text <> old.text) then
      begin
		insert into history (change_number, change_date, change_who, fac_code,
							 number, old_text, old_action, old_explanation, locale)
			values (gen_id(change_num, 1), current_timestamp, current_user,
					old.fac_code, old.number, old.text, old."ACTION",
					old.explanation, old.locale);
      end
end^
 
COMMIT^
SET TERM ; ^

-- Grant permission to the general audience to read these tables.
GRANT SELECT ON FACILITIES    TO PUBLIC;
GRANT SELECT ON HISTORY       TO PUBLIC;
GRANT SELECT ON LOCALES       TO PUBLIC;
GRANT SELECT ON MESSAGES      TO PUBLIC;
GRANT SELECT ON SYMBOLS       TO PUBLIC;
GRANT SELECT ON SYSTEM_ERRORS TO PUBLIC;
GRANT SELECT ON TEMPLATES     TO PUBLIC;
GRANT SELECT ON TRANSMSGS     TO PUBLIC;

COMMIT;

