// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/managedidentities/v1/managed_identities_service.proto

package managedidentities

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the metadata of the long-running operation.
type OpMetadata struct {
	// Output only. The time the operation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,5,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion           string   `protobuf:"bytes,6,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OpMetadata) Reset()         { *m = OpMetadata{} }
func (m *OpMetadata) String() string { return proto.CompactTextString(m) }
func (*OpMetadata) ProtoMessage()    {}
func (*OpMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{0}
}

func (m *OpMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OpMetadata.Unmarshal(m, b)
}
func (m *OpMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OpMetadata.Marshal(b, m, deterministic)
}
func (m *OpMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OpMetadata.Merge(m, src)
}
func (m *OpMetadata) XXX_Size() int {
	return xxx_messageInfo_OpMetadata.Size(m)
}
func (m *OpMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OpMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OpMetadata proto.InternalMessageInfo

func (m *OpMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OpMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *OpMetadata) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *OpMetadata) GetVerb() string {
	if m != nil {
		return m.Verb
	}
	return ""
}

func (m *OpMetadata) GetRequestedCancellation() bool {
	if m != nil {
		return m.RequestedCancellation
	}
	return false
}

func (m *OpMetadata) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

// Request message for
// [CreateMicrosoftAdDomain][google.cloud.managedidentities.v1.CreateMicrosoftAdDomain]
type CreateMicrosoftAdDomainRequest struct {
	// Required. The resource project name and location using the form:
	// `projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The fully qualified domain name.
	// e.g. mydomain.myorganization.com, with the following restrictions:
	//
	//  * Must contain only lowercase letters, numbers, periods and hyphens.
	//  * Must start with a letter.
	//  * Must contain between 2-64 characters.
	//  * Must end with a number or a letter.
	//  * Must not start with period.
	//  * First segement length (mydomain form example above) shouldn't exceed
	//    15 chars.
	//  * The last segment cannot be fully numeric.
	//  * Must be unique within the customer project.
	DomainName string `protobuf:"bytes,2,opt,name=domain_name,json=domainName,proto3" json:"domain_name,omitempty"`
	// Required. A Managed Identity domain resource.
	Domain               *Domain  `protobuf:"bytes,3,opt,name=domain,proto3" json:"domain,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateMicrosoftAdDomainRequest) Reset()         { *m = CreateMicrosoftAdDomainRequest{} }
func (m *CreateMicrosoftAdDomainRequest) String() string { return proto.CompactTextString(m) }
func (*CreateMicrosoftAdDomainRequest) ProtoMessage()    {}
func (*CreateMicrosoftAdDomainRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{1}
}

func (m *CreateMicrosoftAdDomainRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateMicrosoftAdDomainRequest.Unmarshal(m, b)
}
func (m *CreateMicrosoftAdDomainRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateMicrosoftAdDomainRequest.Marshal(b, m, deterministic)
}
func (m *CreateMicrosoftAdDomainRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateMicrosoftAdDomainRequest.Merge(m, src)
}
func (m *CreateMicrosoftAdDomainRequest) XXX_Size() int {
	return xxx_messageInfo_CreateMicrosoftAdDomainRequest.Size(m)
}
func (m *CreateMicrosoftAdDomainRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateMicrosoftAdDomainRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateMicrosoftAdDomainRequest proto.InternalMessageInfo

func (m *CreateMicrosoftAdDomainRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateMicrosoftAdDomainRequest) GetDomainName() string {
	if m != nil {
		return m.DomainName
	}
	return ""
}

func (m *CreateMicrosoftAdDomainRequest) GetDomain() *Domain {
	if m != nil {
		return m.Domain
	}
	return nil
}

// Request message for
// [ResetAdminPassword][google.cloud.managedidentities.v1.ResetAdminPassword]
type ResetAdminPasswordRequest struct {
	// Required. The domain resource name using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetAdminPasswordRequest) Reset()         { *m = ResetAdminPasswordRequest{} }
func (m *ResetAdminPasswordRequest) String() string { return proto.CompactTextString(m) }
func (*ResetAdminPasswordRequest) ProtoMessage()    {}
func (*ResetAdminPasswordRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{2}
}

func (m *ResetAdminPasswordRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetAdminPasswordRequest.Unmarshal(m, b)
}
func (m *ResetAdminPasswordRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetAdminPasswordRequest.Marshal(b, m, deterministic)
}
func (m *ResetAdminPasswordRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetAdminPasswordRequest.Merge(m, src)
}
func (m *ResetAdminPasswordRequest) XXX_Size() int {
	return xxx_messageInfo_ResetAdminPasswordRequest.Size(m)
}
func (m *ResetAdminPasswordRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetAdminPasswordRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ResetAdminPasswordRequest proto.InternalMessageInfo

func (m *ResetAdminPasswordRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Response message for
// [ResetAdminPassword][google.cloud.managedidentities.v1.ResetAdminPassword]
type ResetAdminPasswordResponse struct {
	// A random password. See [admin][google.cloud.managedidentities.v1.Domain.admin] for more information.
	Password             string   `protobuf:"bytes,1,opt,name=password,proto3" json:"password,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetAdminPasswordResponse) Reset()         { *m = ResetAdminPasswordResponse{} }
func (m *ResetAdminPasswordResponse) String() string { return proto.CompactTextString(m) }
func (*ResetAdminPasswordResponse) ProtoMessage()    {}
func (*ResetAdminPasswordResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{3}
}

func (m *ResetAdminPasswordResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetAdminPasswordResponse.Unmarshal(m, b)
}
func (m *ResetAdminPasswordResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetAdminPasswordResponse.Marshal(b, m, deterministic)
}
func (m *ResetAdminPasswordResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetAdminPasswordResponse.Merge(m, src)
}
func (m *ResetAdminPasswordResponse) XXX_Size() int {
	return xxx_messageInfo_ResetAdminPasswordResponse.Size(m)
}
func (m *ResetAdminPasswordResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetAdminPasswordResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ResetAdminPasswordResponse proto.InternalMessageInfo

func (m *ResetAdminPasswordResponse) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

// Request message for
// [ListDomains][google.cloud.managedidentities.v1.ListDomains]
type ListDomainsRequest struct {
	// Required. The resource name of the domain location using the form:
	// `projects/{project_id}/locations/global`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	// If not specified, a default value of 1000 will be used.
	// Regardless of the page_size value, the response may include a partial list.
	// Callers should rely on a response's
	// [next_page_token][google.cloud.managedidentities.v1.ListDomainsResponse.next_page_token]
	// to determine if there are additional results to list.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The `next_page_token` value returned from a previous ListDomainsRequest
	// request, if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter specifying constraints of a list operation.
	// For example, `Domain.fqdn="mydomain.myorginization"`.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results. See
	// [Sorting
	// order](https://cloud.google.com/apis/design/design_patterns#sorting_order)
	// for more information.
	OrderBy              string   `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDomainsRequest) Reset()         { *m = ListDomainsRequest{} }
func (m *ListDomainsRequest) String() string { return proto.CompactTextString(m) }
func (*ListDomainsRequest) ProtoMessage()    {}
func (*ListDomainsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{4}
}

func (m *ListDomainsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDomainsRequest.Unmarshal(m, b)
}
func (m *ListDomainsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDomainsRequest.Marshal(b, m, deterministic)
}
func (m *ListDomainsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDomainsRequest.Merge(m, src)
}
func (m *ListDomainsRequest) XXX_Size() int {
	return xxx_messageInfo_ListDomainsRequest.Size(m)
}
func (m *ListDomainsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDomainsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDomainsRequest proto.InternalMessageInfo

func (m *ListDomainsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDomainsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListDomainsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDomainsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListDomainsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

// Response message for
// [ListDomains][google.cloud.managedidentities.v1.ListDomains]
type ListDomainsResponse struct {
	// A list of Managed Identities Service domains in the project.
	Domains []*Domain `protobuf:"bytes,1,rep,name=domains,proto3" json:"domains,omitempty"`
	// A token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// A list of locations that could not be reached.
	Unreachable          []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDomainsResponse) Reset()         { *m = ListDomainsResponse{} }
func (m *ListDomainsResponse) String() string { return proto.CompactTextString(m) }
func (*ListDomainsResponse) ProtoMessage()    {}
func (*ListDomainsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{5}
}

func (m *ListDomainsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDomainsResponse.Unmarshal(m, b)
}
func (m *ListDomainsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDomainsResponse.Marshal(b, m, deterministic)
}
func (m *ListDomainsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDomainsResponse.Merge(m, src)
}
func (m *ListDomainsResponse) XXX_Size() int {
	return xxx_messageInfo_ListDomainsResponse.Size(m)
}
func (m *ListDomainsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDomainsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDomainsResponse proto.InternalMessageInfo

func (m *ListDomainsResponse) GetDomains() []*Domain {
	if m != nil {
		return m.Domains
	}
	return nil
}

func (m *ListDomainsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListDomainsResponse) GetUnreachable() []string {
	if m != nil {
		return m.Unreachable
	}
	return nil
}

// Request message for [GetDomain][google.cloud.managedidentities.v1.GetDomain]
type GetDomainRequest struct {
	// Required. The domain resource name using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDomainRequest) Reset()         { *m = GetDomainRequest{} }
func (m *GetDomainRequest) String() string { return proto.CompactTextString(m) }
func (*GetDomainRequest) ProtoMessage()    {}
func (*GetDomainRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{6}
}

func (m *GetDomainRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDomainRequest.Unmarshal(m, b)
}
func (m *GetDomainRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDomainRequest.Marshal(b, m, deterministic)
}
func (m *GetDomainRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDomainRequest.Merge(m, src)
}
func (m *GetDomainRequest) XXX_Size() int {
	return xxx_messageInfo_GetDomainRequest.Size(m)
}
func (m *GetDomainRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDomainRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDomainRequest proto.InternalMessageInfo

func (m *GetDomainRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [UpdateDomain][google.cloud.managedidentities.v1.UpdateDomain]
type UpdateDomainRequest struct {
	// Required. Mask of fields to update. At least one path must be supplied in this
	// field. The elements of the repeated paths field may only include
	// fields from [Domain][google.cloud.managedidentities.v1.Domain]:
	//  * `labels`
	//  * `locations`
	//  * `authorized_networks`
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Domain message with updated fields. Only supported fields specified in
	// update_mask are updated.
	Domain               *Domain  `protobuf:"bytes,2,opt,name=domain,proto3" json:"domain,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateDomainRequest) Reset()         { *m = UpdateDomainRequest{} }
func (m *UpdateDomainRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateDomainRequest) ProtoMessage()    {}
func (*UpdateDomainRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{7}
}

func (m *UpdateDomainRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateDomainRequest.Unmarshal(m, b)
}
func (m *UpdateDomainRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateDomainRequest.Marshal(b, m, deterministic)
}
func (m *UpdateDomainRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateDomainRequest.Merge(m, src)
}
func (m *UpdateDomainRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateDomainRequest.Size(m)
}
func (m *UpdateDomainRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateDomainRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateDomainRequest proto.InternalMessageInfo

func (m *UpdateDomainRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateDomainRequest) GetDomain() *Domain {
	if m != nil {
		return m.Domain
	}
	return nil
}

// Request message for
// [DeleteDomain][google.cloud.managedidentities.v1.DeleteDomain]
type DeleteDomainRequest struct {
	// Required. The domain resource name using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteDomainRequest) Reset()         { *m = DeleteDomainRequest{} }
func (m *DeleteDomainRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteDomainRequest) ProtoMessage()    {}
func (*DeleteDomainRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{8}
}

func (m *DeleteDomainRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteDomainRequest.Unmarshal(m, b)
}
func (m *DeleteDomainRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteDomainRequest.Marshal(b, m, deterministic)
}
func (m *DeleteDomainRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteDomainRequest.Merge(m, src)
}
func (m *DeleteDomainRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteDomainRequest.Size(m)
}
func (m *DeleteDomainRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteDomainRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteDomainRequest proto.InternalMessageInfo

func (m *DeleteDomainRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for
// [AttachTrust][google.cloud.managedidentities.v1.AttachTrust]
type AttachTrustRequest struct {
	// Required. The resource domain name, project name and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The domain trust resource.
	Trust                *Trust   `protobuf:"bytes,2,opt,name=trust,proto3" json:"trust,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachTrustRequest) Reset()         { *m = AttachTrustRequest{} }
func (m *AttachTrustRequest) String() string { return proto.CompactTextString(m) }
func (*AttachTrustRequest) ProtoMessage()    {}
func (*AttachTrustRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{9}
}

func (m *AttachTrustRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttachTrustRequest.Unmarshal(m, b)
}
func (m *AttachTrustRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttachTrustRequest.Marshal(b, m, deterministic)
}
func (m *AttachTrustRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachTrustRequest.Merge(m, src)
}
func (m *AttachTrustRequest) XXX_Size() int {
	return xxx_messageInfo_AttachTrustRequest.Size(m)
}
func (m *AttachTrustRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachTrustRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AttachTrustRequest proto.InternalMessageInfo

func (m *AttachTrustRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AttachTrustRequest) GetTrust() *Trust {
	if m != nil {
		return m.Trust
	}
	return nil
}

// Request message for
// [ReconfigureTrust][google.cloud.managedidentities.v1.ReconfigureTrust]
type ReconfigureTrustRequest struct {
	// Required. The resource domain name, project name and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The fully-qualified target domain name which will be in trust with current
	// domain.
	TargetDomainName string `protobuf:"bytes,2,opt,name=target_domain_name,json=targetDomainName,proto3" json:"target_domain_name,omitempty"`
	// Required. The target DNS server IP addresses to resolve the remote domain involved
	// in the trust.
	TargetDnsIpAddresses []string `protobuf:"bytes,3,rep,name=target_dns_ip_addresses,json=targetDnsIpAddresses,proto3" json:"target_dns_ip_addresses,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReconfigureTrustRequest) Reset()         { *m = ReconfigureTrustRequest{} }
func (m *ReconfigureTrustRequest) String() string { return proto.CompactTextString(m) }
func (*ReconfigureTrustRequest) ProtoMessage()    {}
func (*ReconfigureTrustRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{10}
}

func (m *ReconfigureTrustRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReconfigureTrustRequest.Unmarshal(m, b)
}
func (m *ReconfigureTrustRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReconfigureTrustRequest.Marshal(b, m, deterministic)
}
func (m *ReconfigureTrustRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReconfigureTrustRequest.Merge(m, src)
}
func (m *ReconfigureTrustRequest) XXX_Size() int {
	return xxx_messageInfo_ReconfigureTrustRequest.Size(m)
}
func (m *ReconfigureTrustRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReconfigureTrustRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReconfigureTrustRequest proto.InternalMessageInfo

func (m *ReconfigureTrustRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ReconfigureTrustRequest) GetTargetDomainName() string {
	if m != nil {
		return m.TargetDomainName
	}
	return ""
}

func (m *ReconfigureTrustRequest) GetTargetDnsIpAddresses() []string {
	if m != nil {
		return m.TargetDnsIpAddresses
	}
	return nil
}

// Request message for
// [DetachTrust][google.cloud.managedidentities.v1.DetachTrust]
type DetachTrustRequest struct {
	// Required. The resource domain name, project name, and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The domain trust resource to removed.
	Trust                *Trust   `protobuf:"bytes,2,opt,name=trust,proto3" json:"trust,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetachTrustRequest) Reset()         { *m = DetachTrustRequest{} }
func (m *DetachTrustRequest) String() string { return proto.CompactTextString(m) }
func (*DetachTrustRequest) ProtoMessage()    {}
func (*DetachTrustRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{11}
}

func (m *DetachTrustRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetachTrustRequest.Unmarshal(m, b)
}
func (m *DetachTrustRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetachTrustRequest.Marshal(b, m, deterministic)
}
func (m *DetachTrustRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetachTrustRequest.Merge(m, src)
}
func (m *DetachTrustRequest) XXX_Size() int {
	return xxx_messageInfo_DetachTrustRequest.Size(m)
}
func (m *DetachTrustRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetachTrustRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetachTrustRequest proto.InternalMessageInfo

func (m *DetachTrustRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DetachTrustRequest) GetTrust() *Trust {
	if m != nil {
		return m.Trust
	}
	return nil
}

// Request message for
// [ValidateTrust][google.cloud.managedidentities.v1.ValidateTrust]
type ValidateTrustRequest struct {
	// Required. The resource domain name, project name, and location using the form:
	// `projects/{project_id}/locations/global/domains/{domain_name}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The domain trust to validate trust state for.
	Trust                *Trust   `protobuf:"bytes,2,opt,name=trust,proto3" json:"trust,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ValidateTrustRequest) Reset()         { *m = ValidateTrustRequest{} }
func (m *ValidateTrustRequest) String() string { return proto.CompactTextString(m) }
func (*ValidateTrustRequest) ProtoMessage()    {}
func (*ValidateTrustRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5e30133f18884023, []int{12}
}

func (m *ValidateTrustRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ValidateTrustRequest.Unmarshal(m, b)
}
func (m *ValidateTrustRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ValidateTrustRequest.Marshal(b, m, deterministic)
}
func (m *ValidateTrustRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidateTrustRequest.Merge(m, src)
}
func (m *ValidateTrustRequest) XXX_Size() int {
	return xxx_messageInfo_ValidateTrustRequest.Size(m)
}
func (m *ValidateTrustRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidateTrustRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ValidateTrustRequest proto.InternalMessageInfo

func (m *ValidateTrustRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ValidateTrustRequest) GetTrust() *Trust {
	if m != nil {
		return m.Trust
	}
	return nil
}

func init() {
	proto.RegisterType((*OpMetadata)(nil), "google.cloud.managedidentities.v1.OpMetadata")
	proto.RegisterType((*CreateMicrosoftAdDomainRequest)(nil), "google.cloud.managedidentities.v1.CreateMicrosoftAdDomainRequest")
	proto.RegisterType((*ResetAdminPasswordRequest)(nil), "google.cloud.managedidentities.v1.ResetAdminPasswordRequest")
	proto.RegisterType((*ResetAdminPasswordResponse)(nil), "google.cloud.managedidentities.v1.ResetAdminPasswordResponse")
	proto.RegisterType((*ListDomainsRequest)(nil), "google.cloud.managedidentities.v1.ListDomainsRequest")
	proto.RegisterType((*ListDomainsResponse)(nil), "google.cloud.managedidentities.v1.ListDomainsResponse")
	proto.RegisterType((*GetDomainRequest)(nil), "google.cloud.managedidentities.v1.GetDomainRequest")
	proto.RegisterType((*UpdateDomainRequest)(nil), "google.cloud.managedidentities.v1.UpdateDomainRequest")
	proto.RegisterType((*DeleteDomainRequest)(nil), "google.cloud.managedidentities.v1.DeleteDomainRequest")
	proto.RegisterType((*AttachTrustRequest)(nil), "google.cloud.managedidentities.v1.AttachTrustRequest")
	proto.RegisterType((*ReconfigureTrustRequest)(nil), "google.cloud.managedidentities.v1.ReconfigureTrustRequest")
	proto.RegisterType((*DetachTrustRequest)(nil), "google.cloud.managedidentities.v1.DetachTrustRequest")
	proto.RegisterType((*ValidateTrustRequest)(nil), "google.cloud.managedidentities.v1.ValidateTrustRequest")
}

func init() {
	proto.RegisterFile("google/cloud/managedidentities/v1/managed_identities_service.proto", fileDescriptor_5e30133f18884023)
}

var fileDescriptor_5e30133f18884023 = []byte{
	// 1369 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xd7, 0x38, 0x69, 0x9a, 0x3c, 0xb7, 0xa2, 0x4c, 0x5b, 0xe2, 0x1a, 0x5a, 0xdc, 0x2d, 0x7f,
	0xd2, 0xa8, 0xec, 0x36, 0xa9, 0xa0, 0xc8, 0xb4, 0xd0, 0x8d, 0x43, 0x43, 0x25, 0x42, 0x23, 0x37,
	0x0d, 0x52, 0x55, 0x69, 0x19, 0xef, 0x4e, 0x36, 0x4b, 0xd6, 0x3b, 0xcb, 0xce, 0xd8, 0xa1, 0x45,
	0xbd, 0x20, 0xf1, 0x09, 0x10, 0x57, 0x40, 0x15, 0x27, 0xc4, 0x77, 0xe0, 0x1e, 0x81, 0x84, 0x40,
	0x02, 0x29, 0xa7, 0x1e, 0x38, 0x20, 0x71, 0x41, 0x1c, 0x39, 0xa1, 0x9d, 0xd9, 0x8d, 0xd7, 0x76,
	0x5c, 0xaf, 0x43, 0x24, 0x7a, 0xf3, 0xbe, 0x79, 0xef, 0xcd, 0xef, 0xf7, 0xde, 0x9b, 0xf7, 0x9e,
	0x0c, 0x0b, 0x2e, 0x63, 0xae, 0x4f, 0x0d, 0xdb, 0x67, 0x2d, 0xc7, 0x68, 0x92, 0x80, 0xb8, 0xd4,
	0xf1, 0x1c, 0x1a, 0x08, 0x4f, 0x78, 0x94, 0x1b, 0xed, 0xb9, 0x54, 0x68, 0x75, 0xa4, 0x16, 0xa7,
	0x51, 0xdb, 0xb3, 0xa9, 0x1e, 0x46, 0x4c, 0x30, 0x7c, 0x56, 0xf9, 0xd0, 0xa5, 0x0f, 0xbd, 0xcf,
	0x87, 0xde, 0x9e, 0x2b, 0x3f, 0x97, 0x5c, 0x43, 0x42, 0xcf, 0x20, 0x41, 0xc0, 0x04, 0x11, 0x1e,
	0x0b, 0xb8, 0x72, 0x50, 0x9e, 0xce, 0x9c, 0xda, 0xbe, 0x47, 0x03, 0x91, 0x1c, 0x3c, 0x9f, 0x39,
	0x58, 0xf7, 0xa8, 0xef, 0x58, 0x0d, 0xba, 0x41, 0xda, 0x1e, 0x8b, 0x12, 0x85, 0x53, 0x19, 0x85,
	0x88, 0x72, 0xd6, 0x8a, 0x52, 0x54, 0xe5, 0x8b, 0xc3, 0x99, 0xf5, 0x58, 0x9c, 0x4b, 0x2c, 0x7c,
	0x16, 0xb8, 0x51, 0x2b, 0x08, 0xbc, 0xc0, 0x35, 0x58, 0x48, 0xa3, 0x2e, 0xac, 0x95, 0x44, 0x49,
	0x7e, 0x35, 0x5a, 0xeb, 0x09, 0xae, 0x26, 0xe1, 0x9b, 0x3d, 0xa0, 0x77, 0x35, 0x84, 0xd7, 0xa4,
	0x5c, 0x90, 0x66, 0xa8, 0x14, 0xb4, 0x87, 0x05, 0x80, 0x9b, 0xe1, 0x32, 0x15, 0xc4, 0x21, 0x82,
	0xe0, 0x6b, 0x50, 0xb4, 0x23, 0x4a, 0x04, 0xb5, 0x62, 0xc5, 0x12, 0xaa, 0xa0, 0x99, 0xe2, 0x7c,
	0x59, 0x4f, 0x82, 0x9a, 0x7a, 0xd1, 0x57, 0x53, 0x2f, 0x0b, 0x63, 0x8f, 0xcc, 0xb1, 0x3a, 0x28,
	0x9b, 0x58, 0x8a, 0xab, 0x30, 0x49, 0x03, 0x47, 0x99, 0x17, 0xf2, 0x99, 0x1f, 0xa6, 0x81, 0x23,
	0x6d, 0x9f, 0x85, 0x09, 0x41, 0x22, 0x97, 0x8a, 0xd2, 0x58, 0x05, 0xcd, 0x4c, 0xa9, 0xd3, 0x44,
	0x84, 0xa7, 0x61, 0xbc, 0x4d, 0xa3, 0x46, 0x69, 0xbc, 0x73, 0x24, 0x05, 0xb8, 0x0a, 0xcf, 0x44,
	0xf4, 0xa3, 0x16, 0xe5, 0x82, 0x3a, 0x96, 0x4d, 0x02, 0x9b, 0xfa, 0xbe, 0x0c, 0x53, 0xe9, 0x50,
	0x05, 0xcd, 0x4c, 0x2a, 0xd5, 0x93, 0xbb, 0x2a, 0xb5, 0x8c, 0x06, 0x7e, 0x01, 0x8a, 0x24, 0xf4,
	0xac, 0x36, 0x8d, 0x78, 0x6c, 0x30, 0xd1, 0xf1, 0x0d, 0x24, 0xf4, 0xd6, 0x94, 0x58, 0xfb, 0x0d,
	0xc1, 0x99, 0x9a, 0xa4, 0xb8, 0xec, 0xd9, 0x11, 0xe3, 0x6c, 0x5d, 0x98, 0xce, 0x22, 0x6b, 0x12,
	0x2f, 0xa8, 0x2b, 0xb7, 0x78, 0x09, 0x26, 0x42, 0x12, 0xd1, 0x40, 0xc8, 0x98, 0x4d, 0x2d, 0x18,
	0x8f, 0xcc, 0xc2, 0x3f, 0xe6, 0x79, 0xfc, 0x72, 0x7f, 0x09, 0xaa, 0x68, 0x90, 0xd0, 0xe3, 0xba,
	0xcd, 0x9a, 0x46, 0xe2, 0x27, 0x31, 0x8f, 0x11, 0x39, 0x52, 0x62, 0x05, 0x24, 0x09, 0xa1, 0x44,
	0x54, 0xa8, 0x83, 0x92, 0xbf, 0x47, 0x9a, 0x14, 0x5f, 0x87, 0x09, 0xf5, 0x25, 0x23, 0x55, 0x9c,
	0x3f, 0xaf, 0x0f, 0xad, 0x7b, 0x5d, 0x5d, 0xa4, 0x7c, 0x25, 0xd6, 0xda, 0x07, 0x70, 0xaa, 0x4e,
	0x39, 0x15, 0xa6, 0xd3, 0xf4, 0x82, 0x15, 0xc2, 0xf9, 0x16, 0x8b, 0x9c, 0x94, 0x53, 0x0d, 0xc6,
	0x25, 0x86, 0x2e, 0x46, 0x90, 0x9b, 0x91, 0x34, 0xd6, 0x5e, 0x87, 0xf2, 0x5e, 0x37, 0xf0, 0x90,
	0x05, 0x9c, 0xe2, 0x32, 0x4c, 0x86, 0x89, 0x4c, 0x5d, 0x53, 0xdf, 0xfd, 0xd6, 0x1e, 0x21, 0xc0,
	0xef, 0x7a, 0x5c, 0x28, 0x77, 0xfc, 0xc0, 0x23, 0x5d, 0x81, 0xa9, 0x90, 0xb8, 0xd4, 0xe2, 0xde,
	0x7d, 0x15, 0xe7, 0x43, 0x71, 0x6c, 0x50, 0x8c, 0xc0, 0xa5, 0xb7, 0xbc, 0xfb, 0x14, 0x6b, 0x00,
	0x52, 0x43, 0xb0, 0x4d, 0x1a, 0x74, 0x6a, 0x12, 0xd5, 0xa5, 0xe1, 0x6a, 0x2c, 0x8d, 0x6b, 0x76,
	0xdd, 0xf3, 0x05, 0x8d, 0x3a, 0x85, 0x89, 0xea, 0x89, 0x08, 0x9f, 0x81, 0x49, 0x16, 0x39, 0x34,
	0xb2, 0x1a, 0xf7, 0x64, 0x31, 0x26, 0xc7, 0x87, 0xa5, 0x70, 0xe1, 0x9e, 0xf6, 0x0d, 0x82, 0xe3,
	0x5d, 0x14, 0x93, 0xb0, 0xd4, 0xe0, 0xb0, 0x4a, 0x10, 0x2f, 0xa1, 0xca, 0xd8, 0x48, 0xf9, 0xad,
	0xa7, 0x96, 0xf8, 0x25, 0x78, 0x2a, 0xa0, 0x1f, 0x0b, 0x2b, 0x43, 0x41, 0x56, 0x53, 0xfd, 0x68,
	0x2c, 0x5e, 0xd9, 0x65, 0x50, 0x81, 0x62, 0x2b, 0x88, 0x28, 0xb1, 0x37, 0x48, 0xc3, 0xa7, 0xa5,
	0xb1, 0xca, 0xd8, 0xcc, 0x54, 0x3d, 0x2b, 0xd2, 0xde, 0x87, 0x63, 0x4b, 0x54, 0x74, 0x17, 0xfc,
	0x81, 0x14, 0xc7, 0x57, 0x08, 0x8e, 0xdf, 0x0e, 0x1d, 0x22, 0x68, 0xb7, 0xf3, 0x6b, 0x50, 0x6c,
	0x49, 0xb1, 0xec, 0x65, 0x03, 0xdb, 0xd0, 0xf5, 0xb8, 0xdd, 0x2d, 0x13, 0xbe, 0x99, 0x3c, 0x10,
	0x65, 0x13, 0x0b, 0x32, 0x0f, 0xa4, 0xf0, 0x9f, 0x1e, 0xc8, 0x1d, 0x38, 0xbe, 0x48, 0x7d, 0xda,
	0x0b, 0xf0, 0x40, 0xd8, 0x7f, 0x89, 0x00, 0x9b, 0x42, 0x10, 0x7b, 0x63, 0x35, 0x6a, 0x71, 0x71,
	0x90, 0xbe, 0x71, 0x0d, 0x0e, 0x89, 0xd8, 0x69, 0x42, 0x7f, 0x26, 0x07, 0x7d, 0x09, 0x42, 0xb1,
	0x57, 0xb6, 0xda, 0x8f, 0x08, 0xa6, 0xeb, 0xd4, 0x66, 0xc1, 0xba, 0xe7, 0xb6, 0x22, 0x7a, 0xf0,
	0x28, 0xe7, 0x00, 0xab, 0xee, 0x6e, 0x0d, 0xe8, 0x79, 0xc7, 0xd4, 0xf1, 0x62, 0xa7, 0xf3, 0x55,
	0x61, 0x3a, 0x35, 0x09, 0xb8, 0xe5, 0x85, 0x16, 0x71, 0x9c, 0x88, 0x72, 0x4e, 0xb9, 0xaa, 0x5c,
	0x65, 0x77, 0x22, 0xb1, 0x0b, 0xf8, 0x8d, 0xd0, 0x4c, 0x15, 0x64, 0xc0, 0x17, 0xe9, 0x13, 0x1c,
	0xf0, 0xaf, 0x11, 0x9c, 0x58, 0x23, 0xbe, 0x17, 0x97, 0xf1, 0x93, 0x09, 0x71, 0xfe, 0xef, 0xa7,
	0xa1, 0xb4, 0xac, 0x54, 0x6f, 0xec, 0xaa, 0xde, 0x52, 0x3b, 0x18, 0xfe, 0x0b, 0xc1, 0xf4, 0x80,
	0x41, 0x89, 0xcd, 0x1c, 0xd7, 0x3d, 0x7e, 0xc8, 0x96, 0x4f, 0xa7, 0x2e, 0x32, 0x5b, 0x91, 0x7e,
	0x33, 0xdd, 0x8a, 0x34, 0xbe, 0x6d, 0x9e, 0x80, 0x89, 0xe4, 0xba, 0xcc, 0x56, 0xb3, 0x63, 0x9e,
	0x52, 0x2d, 0xff, 0x42, 0xa6, 0xca, 0x92, 0xdf, 0x9f, 0xfe, 0xf2, 0xfb, 0xe7, 0x85, 0xaa, 0x76,
	0x31, 0x5e, 0xc1, 0x3e, 0x51, 0x5a, 0x57, 0xc3, 0x88, 0x7d, 0x48, 0x6d, 0xc1, 0x8d, 0x59, 0xc3,
	0x67, 0xb6, 0xda, 0xb8, 0x0c, 0xd7, 0x67, 0x0d, 0xe2, 0x3f, 0x30, 0x92, 0xee, 0x5a, 0x4d, 0x1a,
	0x04, 0xfe, 0x03, 0x01, 0xee, 0x1f, 0x70, 0xf8, 0x4a, 0x0e, 0xb6, 0x03, 0x27, 0x6f, 0xf9, 0xea,
	0x3e, 0xad, 0xd5, 0xf8, 0xd0, 0x6e, 0xef, 0x98, 0x32, 0xe3, 0x92, 0xdc, 0x3b, 0x5a, 0x4d, 0x92,
	0x8b, 0x05, 0x8f, 0xa3, 0x96, 0x32, 0x33, 0x66, 0x1f, 0x54, 0xa3, 0x3e, 0xdf, 0x55, 0x34, 0x8b,
	0xbf, 0x47, 0x50, 0xcc, 0x4c, 0x2b, 0xfc, 0x6a, 0x0e, 0x94, 0xfd, 0x03, 0xbc, 0xfc, 0xda, 0xa8,
	0x66, 0x09, 0x2b, 0x73, 0xc7, 0x4c, 0x46, 0xb7, 0xe4, 0x35, 0x8f, 0x47, 0x4e, 0x1a, 0xfe, 0x0e,
	0xc1, 0xd4, 0xee, 0x24, 0xc3, 0x97, 0x72, 0x00, 0xe9, 0x9d, 0x7b, 0xe5, 0xfc, 0x83, 0x44, 0x7b,
	0x2b, 0x9b, 0x86, 0x14, 0xee, 0x08, 0x69, 0xc0, 0x3b, 0x08, 0x8e, 0x64, 0xc7, 0x23, 0xce, 0x13,
	0xba, 0x3d, 0xe6, 0xe9, 0xfe, 0x1f, 0x0e, 0x56, 0x68, 0x2e, 0x64, 0xa6, 0xb1, 0x64, 0x63, 0xce,
	0x5f, 0x96, 0x6c, 0xd4, 0xb1, 0x3e, 0x4a, 0x6d, 0xa5, 0x0f, 0xe7, 0x07, 0x04, 0x47, 0xb2, 0xa3,
	0x35, 0x17, 0xb9, 0x3d, 0x66, 0xf1, 0x30, 0x72, 0x74, 0xdb, 0x3c, 0x07, 0x27, 0x7b, 0x57, 0x87,
	0xb7, 0x9b, 0xa1, 0xb8, 0xd7, 0xcd, 0x35, 0x93, 0xab, 0xd9, 0xd1, 0x73, 0xf5, 0x13, 0x82, 0x62,
	0x66, 0x98, 0xe7, 0x7a, 0x1c, 0xfd, 0xc3, 0x7f, 0x18, 0x99, 0xcd, 0x81, 0x99, 0x02, 0xd9, 0xd4,
	0x64, 0x8f, 0x56, 0x19, 0xd2, 0xae, 0x8c, 0xfc, 0xec, 0x49, 0x07, 0x4f, 0xfc, 0xde, 0x3f, 0x2b,
	0xc0, 0xb1, 0xde, 0xf1, 0x8f, 0xab, 0xb9, 0x5a, 0xd3, 0x9e, 0x3b, 0xc3, 0x30, 0x72, 0x5f, 0xa0,
	0x81, 0xec, 0x0c, 0xc5, 0xae, 0x6f, 0x57, 0xb8, 0x30, 0x60, 0x17, 0x90, 0x21, 0xb8, 0xae, 0x99,
	0xfb, 0xe8, 0x7c, 0xdd, 0xd0, 0xe3, 0x38, 0xc4, 0xa9, 0xcd, 0xac, 0x0d, 0xb9, 0x52, 0xdb, 0xbf,
	0x66, 0xfc, 0xbf, 0xa9, 0x75, 0x68, 0x57, 0x6a, 0x7f, 0x45, 0x70, 0xb4, 0x6b, 0xd1, 0xc0, 0x97,
	0x73, 0x90, 0xda, 0x6b, 0x35, 0x19, 0x46, 0xab, 0x99, 0x9b, 0x56, 0x4d, 0x7b, 0x73, 0x64, 0x5a,
	0xed, 0x2c, 0xa2, 0x2a, 0x9a, 0x2d, 0xaf, 0x6e, 0x9b, 0x95, 0x61, 0x5b, 0xd1, 0xcf, 0xa6, 0xbe,
	0x21, 0x44, 0xc8, 0xab, 0x86, 0xb1, 0xb5, 0xb5, 0xd5, 0xbb, 0x32, 0x91, 0x96, 0xd8, 0x50, 0x7f,
	0xd4, 0xbc, 0x12, 0xfa, 0x44, 0xac, 0xb3, 0xa8, 0xb9, 0xf0, 0x27, 0x82, 0x17, 0x6d, 0xd6, 0x1c,
	0x1e, 0xa2, 0x85, 0xd3, 0x83, 0x76, 0xa3, 0x95, 0xb8, 0xf3, 0xac, 0xa0, 0x3b, 0xf5, 0xc4, 0x87,
	0xcb, 0x7c, 0x12, 0xb8, 0x3a, 0x8b, 0x5c, 0xc3, 0xa5, 0x81, 0xec, 0x4b, 0x46, 0x07, 0xc9, 0x63,
	0xfe, 0x29, 0x7a, 0xa3, 0x4f, 0xf8, 0xb0, 0x30, 0xbe, 0x54, 0x5b, 0xbe, 0xf1, 0x6d, 0xe1, 0xec,
	0x92, 0xf2, 0x5d, 0x93, 0xf8, 0xfa, 0x90, 0xe8, 0x6b, 0x73, 0xdb, 0xa9, 0xce, 0x5d, 0xa9, 0x73,
	0xb7, 0x4f, 0xe7, 0xee, 0xda, 0x5c, 0x63, 0x42, 0xa2, 0xb9, 0xf4, 0x6f, 0x00, 0x00, 0x00, 0xff,
	0xff, 0x46, 0xea, 0xba, 0x9c, 0x90, 0x13, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ManagedIdentitiesServiceClient is the client API for ManagedIdentitiesService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ManagedIdentitiesServiceClient interface {
	// Creates a Microsoft AD domain.
	CreateMicrosoftAdDomain(ctx context.Context, in *CreateMicrosoftAdDomainRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Resets a domain's administrator password.
	ResetAdminPassword(ctx context.Context, in *ResetAdminPasswordRequest, opts ...grpc.CallOption) (*ResetAdminPasswordResponse, error)
	// Lists domains in a project.
	ListDomains(ctx context.Context, in *ListDomainsRequest, opts ...grpc.CallOption) (*ListDomainsResponse, error)
	// Gets information about a domain.
	GetDomain(ctx context.Context, in *GetDomainRequest, opts ...grpc.CallOption) (*Domain, error)
	// Updates the metadata and configuration of a domain.
	UpdateDomain(ctx context.Context, in *UpdateDomainRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a domain.
	DeleteDomain(ctx context.Context, in *DeleteDomainRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Adds an AD trust to a domain.
	AttachTrust(ctx context.Context, in *AttachTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the DNS conditional forwarder.
	ReconfigureTrust(ctx context.Context, in *ReconfigureTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Removes an AD trust.
	DetachTrust(ctx context.Context, in *DetachTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Validates a trust state, that the target domain is reachable, and that the
	// target domain is able to accept incoming trust requests.
	ValidateTrust(ctx context.Context, in *ValidateTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type managedIdentitiesServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewManagedIdentitiesServiceClient(cc grpc.ClientConnInterface) ManagedIdentitiesServiceClient {
	return &managedIdentitiesServiceClient{cc}
}

func (c *managedIdentitiesServiceClient) CreateMicrosoftAdDomain(ctx context.Context, in *CreateMicrosoftAdDomainRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/CreateMicrosoftAdDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ResetAdminPassword(ctx context.Context, in *ResetAdminPasswordRequest, opts ...grpc.CallOption) (*ResetAdminPasswordResponse, error) {
	out := new(ResetAdminPasswordResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ResetAdminPassword", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ListDomains(ctx context.Context, in *ListDomainsRequest, opts ...grpc.CallOption) (*ListDomainsResponse, error) {
	out := new(ListDomainsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ListDomains", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) GetDomain(ctx context.Context, in *GetDomainRequest, opts ...grpc.CallOption) (*Domain, error) {
	out := new(Domain)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/GetDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) UpdateDomain(ctx context.Context, in *UpdateDomainRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/UpdateDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) DeleteDomain(ctx context.Context, in *DeleteDomainRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DeleteDomain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) AttachTrust(ctx context.Context, in *AttachTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/AttachTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ReconfigureTrust(ctx context.Context, in *ReconfigureTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ReconfigureTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) DetachTrust(ctx context.Context, in *DetachTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DetachTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *managedIdentitiesServiceClient) ValidateTrust(ctx context.Context, in *ValidateTrustRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ValidateTrust", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ManagedIdentitiesServiceServer is the server API for ManagedIdentitiesService service.
type ManagedIdentitiesServiceServer interface {
	// Creates a Microsoft AD domain.
	CreateMicrosoftAdDomain(context.Context, *CreateMicrosoftAdDomainRequest) (*longrunning.Operation, error)
	// Resets a domain's administrator password.
	ResetAdminPassword(context.Context, *ResetAdminPasswordRequest) (*ResetAdminPasswordResponse, error)
	// Lists domains in a project.
	ListDomains(context.Context, *ListDomainsRequest) (*ListDomainsResponse, error)
	// Gets information about a domain.
	GetDomain(context.Context, *GetDomainRequest) (*Domain, error)
	// Updates the metadata and configuration of a domain.
	UpdateDomain(context.Context, *UpdateDomainRequest) (*longrunning.Operation, error)
	// Deletes a domain.
	DeleteDomain(context.Context, *DeleteDomainRequest) (*longrunning.Operation, error)
	// Adds an AD trust to a domain.
	AttachTrust(context.Context, *AttachTrustRequest) (*longrunning.Operation, error)
	// Updates the DNS conditional forwarder.
	ReconfigureTrust(context.Context, *ReconfigureTrustRequest) (*longrunning.Operation, error)
	// Removes an AD trust.
	DetachTrust(context.Context, *DetachTrustRequest) (*longrunning.Operation, error)
	// Validates a trust state, that the target domain is reachable, and that the
	// target domain is able to accept incoming trust requests.
	ValidateTrust(context.Context, *ValidateTrustRequest) (*longrunning.Operation, error)
}

// UnimplementedManagedIdentitiesServiceServer can be embedded to have forward compatible implementations.
type UnimplementedManagedIdentitiesServiceServer struct {
}

func (*UnimplementedManagedIdentitiesServiceServer) CreateMicrosoftAdDomain(ctx context.Context, req *CreateMicrosoftAdDomainRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMicrosoftAdDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ResetAdminPassword(ctx context.Context, req *ResetAdminPasswordRequest) (*ResetAdminPasswordResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetAdminPassword not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ListDomains(ctx context.Context, req *ListDomainsRequest) (*ListDomainsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDomains not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) GetDomain(ctx context.Context, req *GetDomainRequest) (*Domain, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) UpdateDomain(ctx context.Context, req *UpdateDomainRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) DeleteDomain(ctx context.Context, req *DeleteDomainRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDomain not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) AttachTrust(ctx context.Context, req *AttachTrustRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachTrust not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ReconfigureTrust(ctx context.Context, req *ReconfigureTrustRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReconfigureTrust not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) DetachTrust(ctx context.Context, req *DetachTrustRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachTrust not implemented")
}
func (*UnimplementedManagedIdentitiesServiceServer) ValidateTrust(ctx context.Context, req *ValidateTrustRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ValidateTrust not implemented")
}

func RegisterManagedIdentitiesServiceServer(s *grpc.Server, srv ManagedIdentitiesServiceServer) {
	s.RegisterService(&_ManagedIdentitiesService_serviceDesc, srv)
}

func _ManagedIdentitiesService_CreateMicrosoftAdDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMicrosoftAdDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).CreateMicrosoftAdDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/CreateMicrosoftAdDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).CreateMicrosoftAdDomain(ctx, req.(*CreateMicrosoftAdDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ResetAdminPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetAdminPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ResetAdminPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ResetAdminPassword",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ResetAdminPassword(ctx, req.(*ResetAdminPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ListDomains_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDomainsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ListDomains(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ListDomains",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ListDomains(ctx, req.(*ListDomainsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_GetDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).GetDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/GetDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).GetDomain(ctx, req.(*GetDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_UpdateDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).UpdateDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/UpdateDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).UpdateDomain(ctx, req.(*UpdateDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_DeleteDomain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDomainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).DeleteDomain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DeleteDomain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).DeleteDomain(ctx, req.(*DeleteDomainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_AttachTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).AttachTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/AttachTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).AttachTrust(ctx, req.(*AttachTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ReconfigureTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReconfigureTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ReconfigureTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ReconfigureTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ReconfigureTrust(ctx, req.(*ReconfigureTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_DetachTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).DetachTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/DetachTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).DetachTrust(ctx, req.(*DetachTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ManagedIdentitiesService_ValidateTrust_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ValidateTrustRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ManagedIdentitiesServiceServer).ValidateTrust(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.managedidentities.v1.ManagedIdentitiesService/ValidateTrust",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ManagedIdentitiesServiceServer).ValidateTrust(ctx, req.(*ValidateTrustRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ManagedIdentitiesService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.managedidentities.v1.ManagedIdentitiesService",
	HandlerType: (*ManagedIdentitiesServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMicrosoftAdDomain",
			Handler:    _ManagedIdentitiesService_CreateMicrosoftAdDomain_Handler,
		},
		{
			MethodName: "ResetAdminPassword",
			Handler:    _ManagedIdentitiesService_ResetAdminPassword_Handler,
		},
		{
			MethodName: "ListDomains",
			Handler:    _ManagedIdentitiesService_ListDomains_Handler,
		},
		{
			MethodName: "GetDomain",
			Handler:    _ManagedIdentitiesService_GetDomain_Handler,
		},
		{
			MethodName: "UpdateDomain",
			Handler:    _ManagedIdentitiesService_UpdateDomain_Handler,
		},
		{
			MethodName: "DeleteDomain",
			Handler:    _ManagedIdentitiesService_DeleteDomain_Handler,
		},
		{
			MethodName: "AttachTrust",
			Handler:    _ManagedIdentitiesService_AttachTrust_Handler,
		},
		{
			MethodName: "ReconfigureTrust",
			Handler:    _ManagedIdentitiesService_ReconfigureTrust_Handler,
		},
		{
			MethodName: "DetachTrust",
			Handler:    _ManagedIdentitiesService_DetachTrust_Handler,
		},
		{
			MethodName: "ValidateTrust",
			Handler:    _ManagedIdentitiesService_ValidateTrust_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/managedidentities/v1/managed_identities_service.proto",
}
