package org.broadinstitute.barclay.argparser;

import java.lang.annotation.*;

/**
 * Used to annotate @Arguments of a CommandLineProgram that are a workflow output, used by auto WDL generation.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface WorkflowOutput {
    /**
     * @return array of names of required companion files that should travel with this resource. For example,
     * a (Genomic Reference) FASTA file might have two associated companion files that must be supplied as
     * arguments to the workflow, so the WorkflowOutput would use the attribute values:
     *
     * @WorkflowOutput(requiredCompanions = {"referenceDictionary", "referenceIndex" }
     *
     * The associated workflow and workflow input JSON (but not the task) generated by Barclay will contain two
     * additional parameters with these names (the parameters will only be required if the source of the companions
     * is required, otherwise they will be optional), allowing callers to optionally provide name values for
     * the companion files.
     *
     * The additional companion arguments will be included in the workflow output section of the associated WDL.
     */
    String[] requiredCompanions() default {};

    /**
     * @return array of names of optional companion files that should travel with this resource. For example,
     * a (Genomic Reference) FASTA file might have two associated companion files that can optionally be supplied as
     * arguments to the workflow, so the WorkflowOutput would use the attribute values:
     *
     * @WorkflowOutput(optionalCompanions = {"referenceDictionary", "referenceIndex" }
     *
     * The associated workflow and workflow input JSON (but not the task) generated by Barclay will contain two
     * additional optional parameters with these names, allowing callers to optionally provide name values for
     * the companion files.
     *
     * The additional companion arguments will be included in the workflow output section of the associated WDL.
     */
    String[] optionalCompanions() default {};
}
