/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse mèl :
	BILLARD, non joignable par mèl ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant à visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est régi par la licence CeCILL soumise au droit français et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffusée par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accéder à cet en-tête signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accepté les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/

#include <glib.h>
#include <gmodule.h>

/**
 * VisuPluginInitFunc:
 *
 * This kind of method should exist in all plugins with the
 * name '{module_name}Init'. It is called by V_Sim when the module is loaded.
 *
 * Returns: TRUE if it loads correctly.
 */
typedef gboolean (*VisuPluginInitFunc)(void);
/**
 * VisuPluginFreeFunc:
 *
 * This kind of method may exist in all plugins with the
 * name '{module_name}Free'. It is called by V_Sim when it stops.
 *
 * Since: 3.7
 */
typedef void (*VisuPluginFreeFunc)(void);
/**
 * VisuPluginInfoFunc:
 *
 * This kind of method should exist in all plugins it give a description of
 * what the plugin does. It must be named '{module_name}Get_description'.
 *
 * Returns: a string in UTF-8 owned by the plugin.
 */
typedef const gchar* (*VisuPluginInfoFunc)(void);

struct _VisuPlugin;
/**
 * VisuPlugin:
 *
 * Short way to address #_VisuPlugin objects.
 */
typedef struct _VisuPlugin VisuPlugin;

void visu_plugins_init(GError **error);
GList* visu_plugins_getListLoaded();
void visu_plugins_free();

const gchar* visu_plugin_getName(VisuPlugin *plug);
const gchar* visu_plugin_getDescription(VisuPlugin *plug);
const gchar* visu_plugin_getIconPath(VisuPlugin *plug);
const gchar* visu_plugin_getAuthors(VisuPlugin *plug);
void visu_plugin_initGtk(VisuPlugin *plug);
