.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
etruscanvenus \- Draws a 3d immersion of a Klein bottle that smoothly
deforms between the Etruscan Venus surface, the Roman surface, the Boy
surface surface, and the Ida surface.
.SH SYNOPSIS
.B etruscanvenus
[\-display \fIhost:display.screen\fP]
[\-install]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIusecs\fP]
[\-fps]
[\-mode \fIdisplay-mode\fP]
[\-wireframe]
[\-surface]
[\-transparent]
[\-appearance \fIappearance\fP]
[\-solid]
[\-distance-bands]
[\-direction-bands]
[\-colors \fIcolor-scheme\fP]
[\-onesided-colors]
[\-twosided-colors]
[\-distance-colors]
[\-direction-colors]
[\-no-change-colors]
[\-view-mode \fIview-mode\fP]
[\-walk]
[\-turn]
[\-no-deform]
[\-deformation-speed \fIfloat\fP]
[\-initial-deformation \fIfloat\fP]
[\-etruscan-venus]
[\-roman]
[\-boy]
[\-ida]
[\-orientation-marks]
[\-projection \fImode\fP]
[\-perspective]
[\-orthographic]
[\-speed-x \fIfloat\fP]
[\-speed-y \fIfloat\fP]
[\-speed-z \fIfloat\fP]
[\-walk-direction \fIfloat\fP]
[\-walk-speed \fIfloat\fP]
.SH DESCRIPTION
The \fIetruscanvenus\fP program shows a 3d immersion of a Klein bottle
that smoothly deforms between the Etruscan Venus surface, the Roman
surface, the Boy surface, and the Ida surface.  You can walk on the
Klein bottle or turn it in 3d.  Topologically, all surfaces are Klein
bottles, even the Roman and Boy surfaces, which are doubly covered and
therefore appear to be an immersed real projective plane.  The smooth
deformation between these surfaces was constructed by George
K. Francis.
.PP
The Klein bottle is a non-orientable surface.  To make this apparent,
the two-sided color mode can be used.  Alternatively, orientation
markers (curling arrows) can be drawn as a texture map on the surface
of the Klein bottle.  While walking on the Klein bottle, you will
notice that the orientation of the curling arrows changes (which it
must because the Klein bottle is non-orientable).  Since all the
surfaces except the Ida surface have points where the surface normal
is not well defined for some points, walking is only performed on the
Ida surface.
.PP
As mentioned above, the Roman and Boy surfaces are doubly covered and
therefore appear to be an immersed real projective plane.  Since some
of the parameter names are based on this interpretation of the
surface, the geometry of the real projective plane will be briefly
disussed.  The real projective plane is a model for the projective
geometry in 2d space.  One point can be singled out as the origin.  A
line can be singled out as the line at infinity, i.e., a line that
lies at an infinite distance to the origin.  The line at infinity is
topologically a circle.  Points on the line at infinity are also used
to model directions in projective geometry.  Direction and distance
bands refer to this interpretation of the surface.  If direction bands
are used, the bands extend from the origin of the projective plane in
different directions to the line at infinity and back to the origin.
If distance bands are used, the bands lie at constant distances to the
origin.  The same interpretation is used for distance and direction
colors.  Although there is no conceptually equivalent geometric
interpretation for the two Klein bottle surfaces (the Etruscan Venus
and Ida surfaces), the smooth deformation between the surfaces results
in a natural extension of these concepts to the Klein bottle surfaces.
.PP
The immersed surfaces can be projected to the screen either
perspectively or orthographically.  When using the walking mode,
perspective projection to the screen will be used.
.PP
There are three display modes for the Klein bottle: mesh (wireframe),
solid, or transparent.  Furthermore, the appearance of the surface can
be as a solid object or as a set of see-through bands.  The bands can
be distance bands or direction bands, as explained above.
.PP
The colors with with the surface is drawn can be set to one-sided,
two-sided, distance, or direction.  In one-sided mode, the surface is
drawn with the same color on both sides of the underlying triangles.
In two-sided mode, the surface is drawn with one color on one side of
the underlying triangles and the complementary color on the other
side.  Since the surface actually only has one side, the color jumps
from red to green along a line on the surface.  This mode enables you
to see that the surface is non-orientable.  In distance mode, the
surface is displayed with fully saturated colors that depend on the
distance of the points on the projective plane to the origin, as
described above.  If the surface is displayed as distance bands, each
band will be displayed with a different color.  In direction mode, the
surface is displayed with fully saturated colors that depend on the
angle of the points on the projective plane with respect to the origin
(see above for an explanation).  If the surface is displayed as
direction bands, each band will be displayed with a different color.
The colors used to color the surface can either be static or can be
changed dynamically.
.PP
The rotation speed for each of the three coordinate axes around which
the Klein bottle rotates can be chosen.
.PP
Furthermore, in the walking mode the walking direction in the 2d base
square of the surface and the walking speed can be chosen.  The
walking direction is measured as an angle in degrees in the 2d square
that forms the coordinate system of the surface.  A value of 0 or 180
means that the walk is along a circle at a randomly chosen distance
from the origin (parallel to a distance band).  A value of 90 or 270
means that the walk is directly along a direction band.  Any other
value results in a curved path along the surface.  As noted above,
walking is performed only on the Ida surface.
.PP
By default, the immersion of the Klein bottle smoothly deforms between
the Etruscan Venus surface, the Roman surface, the Boy surface, and
the Ida surface.  It is possible to choose the speed of the
deformation.  Furthermore, it is possible to switch the deformation
off.  It is also possible to determine the initial deformation of the
immersion.  This is mostly useful if the deformation is switched off,
in which case it will determine the appearance of the surface.  A
value of 0 corresponds to the Etruscan Venus surface, a value of 1000
to the Roman surface, a value of 2000 to the Boy surface, and a value
of 3000 to the Ida surface.
.PP
This program is inspired by George K. Francis's book "A Topological
Picturebook", Springer, 1987, by George K. Francis's paper "The
Etruscan Venus" in P. Concus, R. Finn, and D. A. Hoffman: "Geometric
Analysis and Computer Graphics", Springer, 1991, and by a video
entitled "The Etruscan Venus" by Donna J. Cox, George K. Francis, and
Raymond L. Idaszak, presented at SIGGRAPH 1989.
.SH OPTIONS
.I etruscanvenus
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 10000, or 1/100th second.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.PP
The following four options are mutually exclusive.  They determine how
the Klein bottle is displayed.
.TP 8
.B \-mode random
Display the Klein bottle in a random display mode (default).
.TP 8
.B \-mode wireframe \fP(Shortcut: \fB\-wireframe\fP)
Display the Klein bottle as a wireframe mesh.
.TP 8
.B \-mode surface \fP(Shortcut: \fB\-surface\fP)
Display the Klein bottle as a solid surface.
.TP 8
.B \-mode transparent \fP(Shortcut: \fB\-transparent\fP)
Display the Klein bottle as a transparent surface.
.PP
The following four options are mutually exclusive.  They determine the
appearance of the Klein bottle.
.TP 8
.B \-appearance random
Display the Klein bottle with a random appearance (default).
.TP 8
.B \-appearance solid \fP(Shortcut: \fB\-solid\fP)
Display the Klein bottle as a solid object.
.TP 8
.B \-appearance distance-bands \fP(Shortcut: \fB\-distance-bands\fP)
Display the Klein bottle as see-through bands that lie at increasing
distances from the origin (see above for an explanation).
.PP
.TP 8
.B \-appearance direction-bands \fP(Shortcut: \fB\-direction-bands\fP)
Display the Klein bottle as see-through bands that lie at increasing
angles with respect to the origin (see above for an explanation).
.PP
The following five options are mutually exclusive.  They determine how
to color the Klein bottle.
.TP 8
.B \-colors random
Display the Klein bottle with a random color scheme (default).
.TP 8
.B \-colors onesided \fP(Shortcut: \fB\-onesided-colors\fP)
Display the Klein bottle with a single color.
.TP 8
.B \-colors twosided \fP(Shortcut: \fB\-twosided-colors\fP)
Display the Klein bottle with two colors: one color on one "side" and
the complementary color on the "other side."
.TP 8
.B \-colors distance \fP(Shortcut: \fB\-distance-colors\fP)
Display the Klein bottle with fully saturated colors that depend on
the distance of the points on the projective plane to the origin (see
above for an explanation).  If the Klein bottle is displayed as
distance bands, each band will be displayed with a different color.
.TP 8
.B \-colors direction \fP(Shortcut: \fB\-direction-colors\fP)
Display the Klein bottle with fully saturated colors that depend on
the angle of the points on the projective plane with respect to the
origin (see above for an explanation).  If the Klein bottle is
displayed as direction bands, each band will be displayed with a
different color.
.PP
The following options determine whether the colors with which the
Klein bottle are displayed are static or are changing dynamically.
.TP 8
.B \-change-colors
Change the colors with which the Klein bottle is displayed
dynamically (default).
.TP 8
.B \-no-change-colors
Use static colors to display the Klein bottle.
.PP
The following three options are mutually exclusive.  They determine
how to view the Klein bottle.
.TP 8
.B \-view-mode random
View the Klein bottle in a random view mode (default).  The walking
mode will be randomly selected in approximately 10% of the cases.
.TP 8
.B \-view-mode turn \fP(Shortcut: \fB\-turn\fP)
View the Klein bottle while it turns in 3d.
.TP 8
.B \-view-mode walk \fP(Shortcut: \fB\-walk\fP)
View the Klein bottle as if walking on its surface.
.PP
The following options determine whether the surface is being deformed.
.TP 8
.B \-deform
Deform the surface smoothly between the Etruscan Venus surface, the
Roman surface, the Boy surface surface, and the Ida surface (default).
.TP 8
.B \-no-deform
Don't deform the surface.
.PP
The following option determines the deformation speed.
.TP 8
.B \-deformation-speed \fIfloat\fP
The deformation speed is measured in percent of some sensible maximum
speed (default: 10.0).
.PP
The following options determine the initial deformation of the
surface.  As described above, this is mostly useful if
\fB\-no-deform\fP is specified.
.TP 8
.B \-initial-deformation \fIfloat\fP
The initial deformation is specified as a number between 0 and 4000.
A value of 0 corresponds to the Etruscan Venus surface, a value of
1000 to the Roman surface, a value of 2000 to the Boy surface, and a
value of 3000 to the Ida surface.  The default value is 0.
.TP 8
.B \-etruscan-venus
This is a shortcut for \fB\-initial-deformation 0\fP.
.TP 8
.B \-roman
This is a shortcut for \fB\-initial-deformation 1000\fP.
.TP 8
.B \-boy
This is a shortcut for \fB\-initial-deformation 2000\fP.
.TP 8
.B \-ida
This is a shortcut for \fB\-initial-deformation 3000\fP.
.PP
The following options determine whether orientation marks are shown on
the Klein bottle.
.TP 8
.B \-orientation-marks
Display orientation marks on the Klein bottle.
.TP 8
.B \-no-orientation-marks
Don't display orientation marks on the Klein bottle (default).
.PP
The following three options are mutually exclusive.  They determine
how the Klain bottle is projected from 3d to 2d (i.e., to the screen).
.TP 8
.B \-projection random
Project the Klein bottle from 3d to 2d using a random projection mode
(default).
.TP 8
.B \-projection perspective \fP(Shortcut: \fB\-perspective\fP)
Project the Klein bottle from 3d to 2d using a perspective projection.
.TP 8
.B \-projection orthographic \fP(Shortcut: \fB\-orthographic\fP)
Project the Klein bottle from 3d to 2d using an orthographic
projection.
.PP
The following three options determine the rotation speed of the Klein
bottle around the three possible axes.  The rotation speed is measured
in degrees per frame.  The speeds should be set to relatively small
values, e.g., less than 4 in magnitude.  In walk mode, all speeds are
ignored.
.TP 8
.B \-speed-x \fIfloat\fP
Rotation speed around the x axis (default: 1.1).
.TP 8
.B \-speed-y \fIfloat\fP
Rotation speed around the y axis (default: 1.3).
.TP 8
.B \-speed-z \fIfloat\fP
Rotation speed around the z axis (default: 1.5).
.PP
The following two options determine the walking speed and direction.
.TP 8
.B \-walk-direction \fIfloat\fP
The walking direction is measured as an angle in degrees in the 2d
square that forms the coordinate system of the surface of the Klein
bottle (default: 83.0).  A value of 0 or 180 means that the walk is
along a circle at a randomly chosen distance from the origin (parallel
to a distance band).  A value of 90 or 270 means that the walk is
directly along a direction band.  Any other value results in a curved
path along the surface.  As noted above, walking is performed only on
the Ida surface.
.TP 8
.B \-walk-speed \fIfloat\fP
The walking speed is measured in percent of some sensible maximum
speed (default: 20.0).
.SH INTERACTION
If you run this program in standalone mode in its turn mode, you can
rotate the Klein bottle by dragging the mouse while pressing the left
mouse button.  This rotates the Klein bottle in 3d.  To examine the
Klein bottle at your leisure, it is best to set all speeds to 0.
Otherwise, the Klein bottle will rotate while the left mouse button is
not pressed.  This kind of interaction is not available in the walk
mode.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2019-2020 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 05-jan-2020.
